/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import java.util.ArrayList;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;

public class RuntimeTreeContentProvider
extends AbstractTreeContentProvider {
    public static final byte STYLE_VENDOR = 1;
    public static final byte STYLE_VERSION = 2;
    public static final byte STYLE_TYPE = 3;

    public RuntimeTreeContentProvider(byte style) {
        super(style);
    }

    public void fillTree() {
        this.clean();
        ArrayList<IRuntime> list = new ArrayList<IRuntime>();
        if (this.style != 0) {
            IRuntime[] runtimes = ServerCore.getRuntimes();
            if (runtimes != null) {
                int size = runtimes.length;
                int i = 0;
                while (i < size) {
                    IRuntimeType runtimeType = runtimes[i].getRuntimeType();
                    try {
                        AbstractTreeContentProvider.TreeElement ele = null;
                        if (this.style == 1) {
                            ele = this.getOrCreate(list, runtimeType.getVendor());
                        } else if (this.style == 2) {
                            ele = this.getOrCreate(list, runtimeType.getVersion());
                        } else if (this.style == 3) {
                            ele = this.getOrCreate(list, runtimeType.getName());
                        }
                        ele.contents.add(runtimes[i]);
                        this.elementToParentMap.put(runtimes[i], ele);
                    }
                    catch (Exception e) {
                        Trace.trace(Trace.WARNING, "Error in runtime content provider", e);
                    }
                    ++i;
                }
            }
        } else {
            IRuntime[] runtimes = ServerCore.getRuntimes();
            if (runtimes != null) {
                int size = runtimes.length;
                int i = 0;
                while (i < size) {
                    list.add(runtimes[i]);
                    ++i;
                }
            }
        }
        this.elements = list.toArray();
    }
}

