/*******************************************************************************
 * Copyright (c) 2006 BEA Systems, Inc. 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    rfrost@bea.com - initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.server.generic.weblogic;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.core.internal.publishers.AbstractModuleAssembler;
import org.eclipse.jst.server.generic.core.internal.publishers.EarModuleAssembler;
import org.eclipse.wst.server.core.IModule;

/**
 * Subclass of <code>EarModuleAssembler</code> that supports fully exploded EAR assemblies.
 */
public class GenericWebLogicEarAssembler extends EarModuleAssembler {

	public GenericWebLogicEarAssembler(IModule module, GenericServer server, IPath assembleRoot) {
		super(module, server, assembleRoot);
	}
	
	/**
	 * Override to assemble EAR with child modules exploded underneath rather than
	 * packed as archives.
	 * @see org.eclipse.jst.server.generic.core.internal.publishers.EarModuleAssembler#assemble(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public IPath assemble(final IProgressMonitor monitor) throws CoreException {
		Trace.trace(Trace.FINER, "GenericWebLogicEarAssembler: assembling EAR, root: " + fAssembleRoot); //$NON-NLS-1$ 
		final IPath parent = copyModule(fModule,monitor);
		final IEnterpriseApplication earModule = (IEnterpriseApplication)fModule.loadAdapter(IEnterpriseApplication.class, monitor);
		final IModule[] childModules = earModule.getModules();
		for (int i = 0; i < childModules.length; i++) {
			final IModule module = childModules[i];
			final String uri = earModule.getURI(module);
			if(uri == null) {
				final IStatus status = new Status(IStatus.ERROR, CorePlugin.PLUGIN_ID, 0,	"unable to assemble module null uri",null ); //$NON-NLS-1$
				throw new CoreException(status);
			}
				
			assembleChildModule(module,uri, parent);
		}
		return parent;
	}

	/**
	 * Assembles the child underneath the EAR in exploded form.
	 */
	private void assembleChildModule(final IModule module, final String deploymentURI, final IPath destination) throws CoreException {
		final IPath assembleRoot = destination.append(deploymentURI);
		Trace.trace(Trace.FINER, "GenericWebLogicEarAssembler: assembling child, URI " + deploymentURI + ", root: " + assembleRoot); //$NON-NLS-1$ //$NON-NLS-2$ 
		final AbstractModuleAssembler assembler= AbstractModuleAssembler.Factory.getModuleAssembler(module, fServer, assembleRoot);
		assembler.assemble(new NullProgressMonitor());
	}
}
