/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import org.apache.lucene.document.Field;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.ParseContext;

public class ParsedDocument {
    private final Field uid;
    private final Field version;
    private final String id;
    private final String type;
    private final String routing;
    private final long timestamp;
    private final long ttl;
    private final List<ParseContext.Document> documents;
    private BytesReference source;
    private Mapping dynamicMappingsUpdate;
    private String parent;

    public ParsedDocument(Field uid, Field version, String id, String type, String routing, long timestamp, long ttl, List<ParseContext.Document> documents, BytesReference source, Mapping dynamicMappingsUpdate) {
        this.uid = uid;
        this.version = version;
        this.id = id;
        this.type = type;
        this.routing = routing;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.documents = documents;
        this.source = source;
        this.dynamicMappingsUpdate = dynamicMappingsUpdate;
    }

    public Field uid() {
        return this.uid;
    }

    public Field version() {
        return this.version;
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public String routing() {
        return this.routing;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long ttl() {
        return this.ttl;
    }

    public ParseContext.Document rootDoc() {
        return this.documents.get(this.documents.size() - 1);
    }

    public List<ParseContext.Document> docs() {
        return this.documents;
    }

    public BytesReference source() {
        return this.source;
    }

    public void setSource(BytesReference source) {
        this.source = source;
    }

    public ParsedDocument parent(String parent) {
        this.parent = parent;
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public Mapping dynamicMappingsUpdate() {
        return this.dynamicMappingsUpdate;
    }

    public void addDynamicMappingsUpdate(Mapping update) {
        this.dynamicMappingsUpdate = this.dynamicMappingsUpdate == null ? update : this.dynamicMappingsUpdate.merge(update, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Document ").append("uid[").append(this.uid).append("] doc [").append(this.documents).append("]");
        return sb.toString();
    }
}

