/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class CancellableTask
extends Task {
    private final AtomicReference<String> reason = new AtomicReference();

    public CancellableTask(long id, String type, String action, String description) {
        super(id, type, action, description);
    }

    public CancellableTask(long id, String type, String action, String description, TaskId parentTaskId) {
        super(id, type, action, description, parentTaskId);
    }

    final void cancel(String reason) {
        assert (reason != null);
        this.reason.compareAndSet(null, reason);
    }

    public boolean cancelOnParentLeaving() {
        return true;
    }

    public boolean isCancelled() {
        return this.reason.get() != null;
    }

    public String getReasonCancelled() {
        return this.reason.get();
    }
}

