/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.NativeWrapper;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;

public class QPainterPath
extends NativeWrapper {
    QPainterPath() {
    }

    public QPainterPath(Shape s) {
        PathIterator pi = s.getPathIterator(new AffineTransform());
        double[] coords = new double[6];
        this.init(pi.getWindingRule());
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    this.moveTo(coords[0], coords[1]);
                    break;
                }
                case 4: {
                    this.close();
                    break;
                }
                case 1: {
                    this.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    this.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                }
            }
            pi.next();
        }
    }

    public QPainterPath(double x, double y, double w, double h) {
        this.init(0);
        this.moveTo(x, y);
        this.lineTo(x + w, y);
        this.lineTo(x + w, y + h);
        this.lineTo(x, y + h);
        this.lineTo(x, y);
        this.close();
    }

    public QPainterPath(double x1, double y1, double x2, double y2, boolean s) {
        this.init(0);
        this.moveTo(x1, y1);
        this.lineTo(x2, y2);
    }

    public native GeneralPath getPath();

    private native void init(int var1);

    private native void moveTo(double var1, double var3);

    private native void close();

    private native void lineTo(double var1, double var3);

    private native void quadTo(double var1, double var3, double var5, double var7);

    private native void cubicTo(double var1, double var3, double var5, double var7, double var9, double var11);

    public native void dispose();

    public void finalize() {
        this.dispose();
    }
}

