/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.peer.MenuBarPeer;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuBar
extends MenuComponent
implements MenuContainer,
Serializable,
Accessible {
    private static final long serialVersionUID = -4930327919388951260L;
    private static transient long next_menubar_number;
    private Menu helpMenu;
    private Vector menus = new Vector();

    public MenuBar() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public synchronized void setHelpMenu(Menu menu) {
        MenuBarPeer myPeer = (MenuBarPeer)this.getPeer();
        if (this.helpMenu != null) {
            if (myPeer != null) {
                this.helpMenu.removeNotify();
            }
            this.helpMenu.setParent(null);
        }
        this.helpMenu = menu;
        MenuContainer parent = menu.getParent();
        if (parent != null) {
            parent.remove(menu);
        }
        menu.setParent(this);
        if (myPeer != null) {
            menu.addNotify();
            myPeer.addHelpMenu(menu);
        }
    }

    public synchronized Menu add(Menu menu) {
        MenuBarPeer myPeer = (MenuBarPeer)this.getPeer();
        MenuContainer parent = menu.getParent();
        if (parent != null) {
            parent.remove(menu);
        }
        this.menus.addElement(menu);
        menu.setParent(this);
        if (myPeer != null) {
            menu.addNotify();
            myPeer.addMenu(menu);
        }
        return menu;
    }

    public synchronized void remove(int index) {
        Menu m = (Menu)this.menus.remove(index);
        MenuBarPeer mp = (MenuBarPeer)this.getPeer();
        if (mp != null) {
            m.removeNotify();
        }
        m.setParent(null);
        if (mp != null) {
            mp.delMenu(index);
        }
    }

    @Override
    public void remove(MenuComponent menu) {
        int index = this.menus.indexOf(menu);
        if (index == -1) {
            return;
        }
        this.remove(index);
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    public int countMenus() {
        return this.menus.size() + (this.getHelpMenu() == null ? 0 : 1);
    }

    public Menu getMenu(int index) {
        return (Menu)this.menus.elementAt(index);
    }

    public void addNotify() {
        MenuBarPeer peer = (MenuBarPeer)this.getPeer();
        if (peer == null) {
            peer = this.getToolkit().createMenuBar(this);
            this.setPeer(peer);
        }
        Enumeration e = this.menus.elements();
        while (e.hasMoreElements()) {
            Menu mi = (Menu)e.nextElement();
            mi.addNotify();
            peer.addMenu(mi);
        }
        if (this.helpMenu != null) {
            this.helpMenu.addNotify();
            peer.addHelpMenu(this.helpMenu);
        }
    }

    @Override
    public void removeNotify() {
        Enumeration e = this.menus.elements();
        while (e.hasMoreElements()) {
            Menu mi = (Menu)e.nextElement();
            mi.removeNotify();
        }
        super.removeNotify();
    }

    public synchronized Enumeration<MenuShortcut> shortcuts() {
        Vector<MenuShortcut> shortcuts = new Vector<MenuShortcut>();
        Enumeration e = this.menus.elements();
        while (e.hasMoreElements()) {
            Menu menu = (Menu)e.nextElement();
            if (menu.getShortcut() == null) continue;
            shortcuts.addElement(menu.getShortcut());
        }
        return shortcuts.elements();
    }

    public MenuItem getShortcutMenuItem(MenuShortcut shortcut) {
        Enumeration e = this.menus.elements();
        while (e.hasMoreElements()) {
            Menu menu = (Menu)e.nextElement();
            MenuShortcut s = menu.getShortcut();
            if (s == null || !s.equals(shortcut)) continue;
            return menu;
        }
        return null;
    }

    public void deleteShortcut(MenuShortcut shortcut) {
        MenuItem it;
        while ((it = this.getShortcutMenuItem(shortcut)) != null) {
            it.deleteShortcut();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar();
        }
        return this.accessibleContext;
    }

    @Override
    String generateName() {
        return "menubar" + MenuBar.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_menubar_number++;
    }

    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        private static final long serialVersionUID = -8577604491830083815L;

        protected AccessibleAWTMenuBar() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }
    }
}

