/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.ScrollPane;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import java.util.EventListener;

public class ScrollPaneAdjustable
implements Adjustable,
Serializable {
    private static final long serialVersionUID = -3359745691033257079L;
    ScrollPane sp;
    int orientation;
    int value;
    int minimum;
    int maximum;
    int visibleAmount;
    int unitIncrement = 1;
    int blockIncrement = 1;
    AdjustmentListener adjustmentListener;
    private transient boolean valueIsAdjusting = false;

    ScrollPaneAdjustable(ScrollPane sp, int orientation) {
        this.sp = sp;
        this.orientation = orientation;
    }

    ScrollPaneAdjustable(ScrollPane sp, int orientation, int value, int minimum, int maximum, int visibleAmount, int unitIncrement, int blockIncrement) {
        this.sp = sp;
        this.orientation = orientation;
        this.value = value;
        this.minimum = minimum;
        this.maximum = maximum;
        this.visibleAmount = visibleAmount;
        this.unitIncrement = unitIncrement;
        this.blockIncrement = blockIncrement;
    }

    public void addAdjustmentListener(AdjustmentListener listener) {
        if (listener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.add(this.adjustmentListener, listener);
    }

    public void removeAdjustmentListener(AdjustmentListener listener) {
        if (listener == null) {
            return;
        }
        this.adjustmentListener = AWTEventMulticaster.remove(this.adjustmentListener, listener);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])AWTEventMulticaster.getListeners((EventListener)this.adjustmentListener, AdjustmentListener.class);
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getValue() {
        return this.value;
    }

    public int getVisibleAmount() {
        return this.visibleAmount;
    }

    public void setBlockIncrement(int blockIncrement) {
        this.blockIncrement = blockIncrement;
    }

    public void setMaximum(int maximum) throws AWTError {
        throw new AWTError("Can be set by scrollpane only");
    }

    public void setMinimum(int minimum) {
        throw new AWTError("Can be set by scrollpane only");
    }

    public void setUnitIncrement(int unitIncrement) {
        this.unitIncrement = unitIncrement;
    }

    public void setValue(int value) {
        this.value = value;
        if (value < this.minimum) {
            this.minimum = value;
        }
        if (value > this.maximum) {
            this.maximum = value;
        }
    }

    public void setVisibleAmount(int visibleAmount) {
        throw new AWTError("Can be set by scrollpane only");
    }

    public String paramString() {
        return String.valueOf(this.paramStringHelper()) + ",[" + this.getMinimum() + ".." + this.getMaximum() + "],val=" + this.getValue() + ",vis=" + this.getVisibleAmount() + ",unit=" + this.getUnitIncrement() + ",block=" + this.getBlockIncrement() + ",isAdjusting=" + this.valueIsAdjusting;
    }

    private String paramStringHelper() {
        if (this.getOrientation() == 0) {
            return "horizontal";
        }
        return "vertical";
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }
}

