/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import gnu.java.lang.CPStringBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import javax.swing.text.Position;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JList
extends JComponent
implements Accessible,
Scrollable {
    private static final long serialVersionUID = 4406629526391098046L;
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    boolean dragEnabled;
    ListCellRenderer cellRenderer;
    int fixedCellWidth;
    int fixedCellHeight;
    int layoutOrientation;
    ListModel model;
    Object prototypeCellValue;
    Color selectionBackground;
    Color selectionForeground;
    ListSelectionModel selectionModel;
    int visibleRowCount;
    ListListener listListener;

    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        ListSelectionEvent evt = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
        ListSelectionListener[] listeners = this.getListSelectionListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueChanged(evt);
            ++i;
        }
    }

    public JList() {
        this.init(new DefaultListModel());
    }

    public JList(Object[] items) {
        this.init(this.createListModel(items));
    }

    public JList(Vector<?> items) {
        this.init(this.createListModel(items));
    }

    public JList(ListModel model) {
        this.init(model);
    }

    private void init(ListModel m) {
        if (m == null) {
            throw new IllegalArgumentException("Null model not permitted.");
        }
        this.dragEnabled = false;
        this.fixedCellHeight = -1;
        this.fixedCellWidth = -1;
        this.layoutOrientation = 0;
        this.opaque = true;
        this.visibleRowCount = 8;
        this.cellRenderer = new DefaultListCellRenderer();
        this.listListener = new ListListener();
        this.model = m;
        if (this.model != null) {
            this.model.addListDataListener(this.listListener);
        }
        this.selectionModel = this.createSelectionModel();
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this.listListener);
            this.selectionModel.setSelectionMode(2);
        }
        this.setLayout(null);
        this.updateUI();
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int h) {
        if (this.fixedCellHeight == h) {
            return;
        }
        int old = this.fixedCellHeight;
        this.fixedCellHeight = h;
        this.firePropertyChange("fixedCellHeight", old, h);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int w) {
        if (this.fixedCellWidth == w) {
            return;
        }
        int old = this.fixedCellWidth;
        this.fixedCellWidth = w;
        this.firePropertyChange("fixedCellWidth", old, w);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int vc) {
        if (this.visibleRowCount != vc) {
            int oldValue = this.visibleRowCount;
            this.visibleRowCount = Math.max(vc, 0);
            this.firePropertyChange("visibleRowCount", oldValue, vc);
            this.revalidate();
            this.repaint();
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.getListeners(ListSelectionListener.class);
    }

    public int getSelectionMode() {
        return this.selectionModel.getSelectionMode();
    }

    public void setSelectionMode(int a) {
        this.selectionModel.setSelectionMode(a);
    }

    public void setSelectedIndex(int a) {
        if (a < 0) {
            this.selectionModel.clearSelection();
        } else {
            this.selectionModel.setSelectionInterval(a, a);
        }
    }

    public void setSelectedIndices(int[] a) {
        int i = 0;
        while (i < a.length) {
            this.setSelectedIndex(a[i]);
            ++i;
        }
    }

    public int getSelectedIndex() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public int getFirstVisibleIndex() {
        ComponentOrientation or = this.getComponentOrientation();
        Rectangle r = this.getVisibleRect();
        if (or == ComponentOrientation.RIGHT_TO_LEFT) {
            r.translate((int)r.getWidth() - 1, 0);
        }
        return this.getUI().locationToIndex(this, r.getLocation());
    }

    public int locationToIndex(Point location) {
        return this.getUI().locationToIndex(this, location);
    }

    public Point indexToLocation(int index) {
        return this.getUI().indexToLocation(this, index);
    }

    public int getLastVisibleIndex() {
        ComponentOrientation or = this.getComponentOrientation();
        Rectangle r = this.getVisibleRect();
        r.translate(0, (int)r.getHeight() - 1);
        if (or == ComponentOrientation.LEFT_TO_RIGHT) {
            r.translate((int)r.getWidth() - 1, 0);
        }
        if (this.getUI().locationToIndex(this, r.getLocation()) == -1 && this.indexToLocation((int)(this.getModel().getSize() - 1)).y < r.y) {
            return this.getModel().getSize() - 1;
        }
        return this.getUI().locationToIndex(this, r.getLocation());
    }

    public int[] getSelectedIndices() {
        if (this.selectionModel.isSelectionEmpty()) {
            return new int[0];
        }
        int lo = this.selectionModel.getMinSelectionIndex();
        int hi = this.selectionModel.getMaxSelectionIndex();
        int n = 0;
        int i = lo;
        while (i <= hi) {
            if (this.selectionModel.isSelectedIndex(i)) {
                ++n;
            }
            ++i;
        }
        int[] v = new int[n];
        int j = 0;
        i = lo;
        while (i <= hi) {
            if (this.selectionModel.isSelectedIndex(i)) {
                v[j++] = i;
            }
            ++i;
        }
        return v;
    }

    public boolean isSelectedIndex(int a) {
        return this.selectionModel.isSelectedIndex(a);
    }

    public Object getSelectedValue() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.getModel().getElementAt(index);
    }

    public Object[] getSelectedValues() {
        int[] idx = this.getSelectedIndices();
        Object[] v = new Object[idx.length];
        int i = 0;
        while (i < idx.length) {
            v[i] = this.getModel().getElementAt(idx[i]);
            ++i;
        }
        return v;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color c) {
        if (this.selectionBackground == c) {
            return;
        }
        Color old = this.selectionBackground;
        this.selectionBackground = c;
        this.firePropertyChange("selectionBackground", old, c);
        this.repaint();
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color c) {
        if (this.selectionForeground == c) {
            return;
        }
        Color old = this.selectionForeground;
        this.selectionForeground = c;
        this.firePropertyChange("selectionForeground", old, c);
    }

    public void setSelectedValue(Object obj, boolean scroll) {
        int i = 0;
        while (i < this.model.getSize()) {
            if (this.model.getElementAt(i).equals(obj)) {
                this.setSelectedIndex(i);
                if (!scroll) break;
                this.ensureIndexIsVisible(i);
                break;
            }
            ++i;
        }
    }

    public void ensureIndexIsVisible(int i) {
        Rectangle r = this.getUI().getCellBounds(this, i, i);
        if (r != null) {
            this.scrollRectToVisible(r);
        }
    }

    public void setListData(Object[] listData) {
        this.setModel(this.createListModel(listData));
    }

    private ListModel createListModel(final Object[] items) {
        return new AbstractListModel(){

            public int getSize() {
                return items.length;
            }

            public Object getElementAt(int i) {
                return items[i];
            }
        };
    }

    private ListModel createListModel(final Vector items) {
        return new AbstractListModel(){

            public int getSize() {
                return items.size();
            }

            public Object getElementAt(int i) {
                return items.get(i);
            }
        };
    }

    public void setListData(final Vector<?> listData) {
        this.setModel(new AbstractListModel(){

            public int getSize() {
                return listData.size();
            }

            public Object getElementAt(int i) {
                return listData.elementAt(i);
            }
        });
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        if (this.cellRenderer == renderer) {
            return;
        }
        ListCellRenderer old = this.cellRenderer;
        this.cellRenderer = renderer;
        this.firePropertyChange("cellRenderer", old, renderer);
        this.revalidate();
        this.repaint();
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("Null 'model' argument.");
        }
        if (this.model == model) {
            return;
        }
        if (this.model != null) {
            this.model.removeListDataListener(this.listListener);
        }
        ListModel old = this.model;
        this.model = model;
        if (this.model != null) {
            this.model.addListDataListener(this.listListener);
        }
        this.firePropertyChange("model", old, model);
        this.revalidate();
        this.repaint();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel model) {
        if (this.selectionModel == model) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeListSelectionListener(this.listListener);
        }
        ListSelectionModel old = this.selectionModel;
        this.selectionModel = model;
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this.listListener);
        }
        this.firePropertyChange("selectionModel", old, model);
        this.revalidate();
        this.repaint();
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void setUI(ListUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return "ListUI";
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(Object obj) {
        if (this.prototypeCellValue == obj) {
            return;
        }
        Object old = this.prototypeCellValue;
        Component comp = this.getCellRenderer().getListCellRendererComponent(this, obj, 0, false, false);
        Dimension d = comp.getPreferredSize();
        this.fixedCellWidth = d.width;
        this.fixedCellHeight = d.height;
        this.prototypeCellValue = obj;
        this.firePropertyChange("prototypeCellValue", old, obj);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return new AccessibleJList();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getLayoutOrientation() != 0) {
            return this.getPreferredSize();
        }
        int size = this.getModel().getSize();
        if (this.fixedCellHeight != -1 && this.fixedCellWidth != -1) {
            return new Dimension(this.fixedCellWidth, size * this.fixedCellHeight);
        }
        if (size == 0) {
            if (this.fixedCellWidth == -1) {
                return new Dimension(256, 16 * this.getVisibleRowCount());
            }
            return new Dimension(this.fixedCellWidth, 16 * this.getVisibleRowCount());
        }
        int prefWidth = this.fixedCellWidth != -1 ? this.fixedCellWidth : this.getPreferredSize().width;
        int prefHeight = this.fixedCellHeight != -1 ? this.fixedCellHeight : this.getVisibleRowCount() * this.getCellBounds((int)0, (int)0).height;
        return new Dimension(prefWidth, prefHeight);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        Rectangle b;
        int i;
        int unit = -1;
        if (orientation == 1) {
            int row = this.getFirstVisibleIndex();
            if (row == -1) {
                unit = 0;
            } else if (direction > 0) {
                Rectangle bounds = this.getCellBounds(row, row);
                unit = bounds != null ? bounds.height - (visibleRect.y - bounds.y) : 0;
            } else {
                Rectangle bounds = this.getCellBounds(row, row);
                if (row == 0 && bounds.y == visibleRect.y) {
                    unit = 0;
                } else if (bounds.y == visibleRect.y) {
                    Point loc = bounds.getLocation();
                    --loc.y;
                    int prev = this.locationToIndex(loc);
                    Rectangle prevR = this.getCellBounds(prev, prev);
                    unit = prevR == null || prevR.y >= bounds.y ? 0 : prevR.height;
                } else {
                    unit = visibleRect.y - bounds.y;
                }
            }
        } else if (orientation == 0 && this.getLayoutOrientation() != 0 && (i = this.locationToIndex(visibleRect.getLocation())) != -1 && (b = this.getCellBounds(i, i)) != null) {
            unit = b.x != visibleRect.x ? (direction < 0 ? Math.abs(b.x - visibleRect.x) : b.width + b.x - visibleRect.x) : b.width;
        }
        if (unit == -1) {
            Font f = this.getFont();
            unit = f != null ? f.getSize() : 1;
        }
        return unit;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        int block = -1;
        if (orientation == 1) {
            block = visibleRect.height;
            if (direction > 0) {
                Rectangle lastR;
                Point p = new Point(visibleRect.x, visibleRect.y + visibleRect.height - 1);
                int last = this.locationToIndex(p);
                if (last != -1 && (lastR = this.getCellBounds(last, last)) != null && (block = lastR.y - visibleRect.y) == 0 && last < this.getModel().getSize() - 1) {
                    block = lastR.height;
                }
            } else {
                Point p = new Point(visibleRect.x, visibleRect.y - visibleRect.height);
                int newFirst = this.locationToIndex(p);
                if (newFirst != -1) {
                    int first = this.getFirstVisibleIndex();
                    if (first == -1) {
                        first = this.locationToIndex(visibleRect.getLocation());
                    }
                    Rectangle newFirstR = this.getCellBounds(newFirst, newFirst);
                    Rectangle firstR = this.getCellBounds(first, first);
                    if (newFirstR != null && firstR != null) {
                        while (newFirstR.y + visibleRect.height < firstR.y + firstR.height && newFirstR.y < firstR.y) {
                            newFirstR = this.getCellBounds(++newFirst, newFirst);
                        }
                        block = visibleRect.y - newFirstR.y;
                        if (block <= 0 && newFirstR.y > 0 && (newFirstR = this.getCellBounds(--newFirst, newFirst)) != null) {
                            block = visibleRect.y - newFirstR.y;
                        }
                    }
                }
            }
        } else if (orientation == 0 && this.getLayoutOrientation() != 0) {
            block = visibleRect.width;
            if (direction > 0) {
                Rectangle lastR;
                Point p = new Point(visibleRect.x + visibleRect.width + 1, visibleRect.y);
                int last = this.locationToIndex(p);
                if (last != -1 && (lastR = this.getCellBounds(last, last)) != null) {
                    block = lastR.x - visibleRect.x;
                    if (block < 0) {
                        block += lastR.width;
                    } else if (block == 0 && last < this.getModel().getSize() - 1) {
                        block = lastR.width;
                    }
                }
            } else {
                Rectangle firstR;
                Point p = new Point(visibleRect.x - visibleRect.width, visibleRect.y);
                int first = this.locationToIndex(p);
                if (first != -1 && (firstR = this.getCellBounds(first, first)) != null) {
                    block = firstR.x < visibleRect.x - visibleRect.width ? (firstR.x + firstR.width > visibleRect.x ? visibleRect.x - firstR.x : visibleRect.x - firstR.x - firstR.width) : visibleRect.x - firstR.x;
                }
            }
        }
        return block;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        boolean retVal = false;
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            Dimension pref = this.getPreferredSize();
            if (viewport.getSize().width > pref.width) {
                retVal = true;
            }
            if (this.getLayoutOrientation() == 2 && this.getVisibleRowCount() <= 0) {
                retVal = true;
            }
        }
        return retVal;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        boolean retVal = false;
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            Dimension pref = this.getPreferredSize();
            if (viewport.getSize().height > pref.height) {
                retVal = true;
            }
            if (this.getLayoutOrientation() == 1 && this.getVisibleRowCount() <= 0) {
                retVal = true;
            }
        }
        return retVal;
    }

    public int getAnchorSelectionIndex() {
        return this.selectionModel.getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.selectionModel.getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.selectionModel.getMaxSelectionIndex();
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    public void setSelectionInterval(int anchor, int lead) {
        this.selectionModel.setSelectionInterval(anchor, lead);
    }

    public void addSelectionInterval(int anchor, int lead) {
        this.selectionModel.addSelectionInterval(anchor, lead);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.selectionModel.removeSelectionInterval(index0, index1);
    }

    public boolean getValueIsAdjusting() {
        return this.selectionModel.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean isAdjusting) {
        this.selectionModel.setValueIsAdjusting(isAdjusting);
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean enabled) {
        this.dragEnabled = enabled;
    }

    public int getLayoutOrientation() {
        return this.layoutOrientation;
    }

    public void setLayoutOrientation(int orientation) {
        if (orientation < 0 || orientation > 2) {
            throw new IllegalArgumentException();
        }
        if (this.layoutOrientation == orientation) {
            return;
        }
        int old = this.layoutOrientation;
        this.layoutOrientation = orientation;
        this.firePropertyChange("layoutOrientation", old, orientation);
    }

    public Rectangle getCellBounds(int index0, int index1) {
        ListUI ui = this.getUI();
        Rectangle bounds = null;
        if (ui != null) {
            bounds = ui.getCellBounds(this, index0, index1);
        }
        return bounds;
    }

    public int getNextMatch(String prefix, int startIndex, Position.Bias direction) {
        if (prefix == null) {
            throw new IllegalArgumentException("The argument 'prefix' must not be null.");
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("The argument 'startIndex' must not be less than zero.");
        }
        this.model.getSize();
        if (startIndex >= this.model.getSize()) {
            throw new IllegalArgumentException("The argument 'startIndex' must not be greater than the number of elements in the ListModel.");
        }
        int result = -1;
        int current = startIndex;
        int delta = -1;
        int itemCount = this.model.getSize();
        boolean finished = false;
        prefix = prefix.toUpperCase();
        if (direction == Position.Bias.Forward) {
            delta = 1;
        }
        while (!finished) {
            String itemStr = this.model.getElementAt(current).toString().toUpperCase();
            if (itemStr.startsWith(prefix)) {
                return current;
            }
            current = (current += delta) == -1 ? (current += itemCount) : (current %= itemCount);
            boolean bl = finished = current == startIndex;
        }
        return result;
    }

    @Override
    protected String paramString() {
        CPStringBuilder sb = new CPStringBuilder(super.paramString());
        sb.append(",fixedCellHeight=").append(this.getFixedCellHeight());
        sb.append(",fixedCellWidth=").append(this.getFixedCellWidth());
        sb.append(",selectionBackground=");
        if (this.getSelectionBackground() != null) {
            sb.append(this.getSelectionBackground());
        }
        sb.append(",selectionForeground=");
        if (this.getSelectionForeground() != null) {
            sb.append(this.getSelectionForeground());
        }
        sb.append(",visibleRowCount=").append(this.getVisibleRowCount());
        sb.append(",layoutOrientation=").append(this.getLayoutOrientation());
        return sb.toString();
    }

    protected class AccessibleJList
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    PropertyChangeListener,
    ListSelectionListener,
    ListDataListener {
        public AccessibleJList() {
            super(JList.this);
        }

        public int getAccessibleSelectionCount() {
            return JList.this.getSelectedIndices().length;
        }

        public Accessible getAccessibleSelection(int n) {
            return new AccessibleJListChild(JList.this, JList.this.getSelectedIndices()[n]);
        }

        public boolean isAccessibleChildSelected(int n) {
            return JList.this.isSelectedIndex(n);
        }

        public void addAccessibleSelection(int i) {
            JList.this.addSelectionInterval(i, i);
        }

        public void removeAccessibleSelection(int i) {
            JList.this.removeSelectionInterval(i, i);
        }

        public void clearAccessibleSelection() {
            JList.this.clearSelection();
        }

        public void selectAllAccessibleSelection() {
            JList.this.addSelectionInterval(0, JList.this.getModel().getSize());
        }

        public void valueChanged(ListSelectionEvent event) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
            this.firePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }

        public void contentsChanged(ListDataEvent event) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void intervalAdded(ListDataEvent event) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void intervalRemoved(ListDataEvent event) {
            this.firePropertyChange("AccessibleVisibleData", Boolean.FALSE, Boolean.TRUE);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("model")) {
                ListModel oldModel = (ListModel)e.getOldValue();
                oldModel.removeListDataListener(this);
                ListModel newModel = (ListModel)e.getNewValue();
                newModel.addListDataListener(this);
            } else if (propertyName.equals("selectionModel")) {
                ListSelectionModel oldModel = (ListSelectionModel)e.getOldValue();
                oldModel.removeListSelectionListener(this);
                ListSelectionModel cfr_ignored_0 = (ListSelectionModel)e.getNewValue();
                oldModel.addListSelectionListener(this);
            }
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet s = super.getAccessibleStateSet();
            if (JList.this.getSelectionMode() != 0) {
                s.add(AccessibleState.MULTISELECTABLE);
            }
            return s;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleAt(Point p) {
            int childIndex = JList.this.locationToIndex(p);
            return this.getAccessibleChild(childIndex);
        }

        public int getAccessibleChildrenCount() {
            return JList.this.getModel().getSize();
        }

        public Accessible getAccessibleChild(int n) {
            if (JList.this.getModel().getSize() <= n) {
                return null;
            }
            return new AccessibleJListChild(JList.this, n);
        }

        protected class AccessibleJListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            JList parent;
            int listIndex;
            Cursor cursor = Cursor.getDefaultCursor();

            public AccessibleJListChild(JList list2, int index) {
                this.parent = list2;
                this.listIndex = index;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public Color getBackground() {
                return this.parent.getBackground();
            }

            public void setBackground(Color color) {
            }

            public Color getForeground() {
                return this.parent.getForeground();
            }

            public void setForeground(Color color) {
            }

            public Cursor getCursor() {
                return this.cursor;
            }

            public void setCursor(Cursor cursor) {
                this.cursor = cursor;
            }

            public Font getFont() {
                return this.parent.getFont();
            }

            public void setFont(Font font) {
            }

            public FontMetrics getFontMetrics(Font font) {
                return this.parent.getFontMetrics(font);
            }

            public boolean isEnabled() {
                return this.parent.isEnabled();
            }

            public void setEnabled(boolean b) {
            }

            public boolean isVisible() {
                return this.listIndex >= this.parent.getFirstVisibleIndex() && this.listIndex <= this.parent.getLastVisibleIndex();
            }

            public void setVisible(boolean b) {
            }

            public boolean isShowing() {
                return this.isVisible() && this.parent.isShowing();
            }

            public boolean contains(Point point) {
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                Point loc = this.getLocation();
                SwingUtilities.convertPointToScreen(loc, this.parent);
                return loc;
            }

            public Point getLocation() {
                return this.parent.indexToLocation(this.listIndex);
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                return this.parent.getCellBounds(this.listIndex, this.listIndex);
            }

            public void setBounds(Rectangle rectangle) {
            }

            public Dimension getSize() {
                Rectangle b = this.getBounds();
                return b.getSize();
            }

            public void setSize(Dimension dimension) {
            }

            public Accessible getAccessibleAt(Point point) {
                return null;
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public void requestFocus() {
                this.parent.requestFocus();
            }

            public void addFocusListener(FocusListener listener) {
                this.parent.addFocusListener(listener);
            }

            public void removeFocusListener(FocusListener listener) {
                this.parent.removeFocusListener(listener);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet states = new AccessibleStateSet();
                if (this.isVisible()) {
                    states.add(AccessibleState.VISIBLE);
                }
                if (this.isShowing()) {
                    states.add(AccessibleState.SHOWING);
                }
                if (this.isFocusTraversable()) {
                    states.add(AccessibleState.FOCUSABLE);
                }
                if (this.parent.isEnabled()) {
                    states.add(AccessibleState.SELECTABLE);
                }
                if (this.parent.isSelectedIndex(this.listIndex)) {
                    states.add(AccessibleState.SELECTED);
                }
                return states;
            }

            public int getAccessibleIndexInParent() {
                return this.listIndex;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public Accessible getAccessibleChild(int i) {
                return null;
            }

            public Locale getLocale() {
                return this.parent.getLocale();
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
            }
        }
    }

    private class ListListener
    implements ListSelectionListener,
    ListDataListener {
        private ListListener() {
        }

        public void contentsChanged(ListDataEvent event) {
            JList.this.revalidate();
            JList.this.repaint();
        }

        public void intervalAdded(ListDataEvent event) {
            JList.this.revalidate();
            JList.this.repaint();
        }

        public void intervalRemoved(ListDataEvent event) {
            JList.this.revalidate();
            JList.this.repaint();
        }

        public void valueChanged(ListSelectionEvent event) {
            JList.this.fireSelectionValueChanged(event.getFirstIndex(), event.getLastIndex(), event.getValueIsAdjusting());
            JList.this.repaint();
        }
    }
}

