/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.io.Reader;

class CSSParser {
    private static final int IDENTIFIER = 1;
    private static final int BRACKET_OPEN = 2;
    private static final int BRACKET_CLOSE = 3;
    private static final int BRACE_OPEN = 4;
    private static final int BRACE_CLOSE = 5;
    private static final int PAREN_OPEN = 6;
    private static final int PAREN_CLOSE = 7;
    private static final int END = -1;
    private static final char[] charMapping = null;
    private boolean didPushChar;
    private int pushedChar;
    private int[] unitStack;
    private int stackCount;
    private Reader reader;
    private boolean encounteredRuleSet;
    private CSSParserCallback callback;
    private char[] tokenBuffer = new char[10];
    private int tokenBufferLength;
    private boolean readWS;

    CSSParser() {
    }

    private void append(char c) {
        if (this.tokenBuffer.length >= this.tokenBufferLength) {
            char[] temp = new char[this.tokenBufferLength * 2];
            if (this.tokenBuffer != null) {
                System.arraycopy(this.tokenBuffer, 0, temp, 0, this.tokenBufferLength);
            }
            temp[this.tokenBufferLength] = c;
            this.tokenBuffer = temp;
        } else {
            this.tokenBuffer[this.tokenBufferLength] = c;
        }
        ++this.tokenBufferLength;
    }

    private int nextToken(char c) throws IOException {
        this.readWS = false;
        int next = this.readWS();
        switch (next) {
            case 34: {
                if (this.tokenBufferLength > 0) {
                    --this.tokenBufferLength;
                }
                return 1;
            }
            case 39: {
                if (this.tokenBufferLength > 0) {
                    --this.tokenBufferLength;
                }
                return 1;
            }
            case 40: {
                return 6;
            }
            case 41: {
                return 7;
            }
            case 123: {
                return 4;
            }
            case 125: {
                return 5;
            }
            case 91: {
                return 2;
            }
            case 93: {
                return 3;
            }
            case -1: {
                return -1;
            }
        }
        this.pushChar(next);
        this.getIdentifier(c);
        return 1;
    }

    private int readChar() throws IOException {
        if (this.didPushChar) {
            this.didPushChar = false;
            return this.pushedChar;
        }
        return this.reader.read();
    }

    void parse(Reader reader, CSSParserCallback callback, boolean parsingDeclaration) throws IOException {
        this.reader = reader;
        this.callback = callback;
        try {
            if (!parsingDeclaration) {
                while (this.getNextStatement()) {
                }
            } else {
                this.parseDeclarationBlock();
            }
        }
        catch (IOException iOException) {}
    }

    private int readWS() throws IOException {
        int next = this.readChar();
        while (Character.isWhitespace((char)next)) {
            this.readWS = true;
            int tempNext = this.readChar();
            if (tempNext == -1) {
                return next;
            }
            next = tempNext;
        }
        return -1;
    }

    private boolean getNextStatement() throws IOException {
        int c = this.nextToken('\u0000');
        switch (c) {
            case 2: 
            case 4: 
            case 6: {
                this.parseTillClosed(c);
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                throw new IOException("Not a proper statement.");
            }
            case 1: {
                if (this.tokenBuffer[0] == '@') {
                    this.parseAtRule();
                    break;
                }
                this.parseRuleSet();
                break;
            }
            case -1: {
                return false;
            }
        }
        return true;
    }

    private void parseAtRule() throws IOException {
    }

    private void parseRuleSet() throws IOException {
    }

    private boolean parseSelectors() throws IOException {
        return false;
    }

    private void parseDeclarationBlock() throws IOException {
    }

    private int parseDeclaration() throws IOException {
        return 0;
    }

    private int parseIdentifiers(char c, boolean wantsBlocks) throws IOException {
        return 0;
    }

    private void parseTillClosed(int i) throws IOException {
    }

    private boolean getIdentifier(char c) throws IOException {
        return false;
    }

    private void readTill(char c) throws IOException {
    }

    private void readComment() throws IOException {
    }

    private void startBlock(int start) {
    }

    private void endBlock(int end) {
    }

    private boolean inBlock() {
        return false;
    }

    private void pushChar(int c) throws IOException {
        if (this.didPushChar) {
            throw new IOException("pushChar called twice.");
        }
        this.didPushChar = true;
        this.pushedChar = c;
    }

    static interface CSSParserCallback {
        public void handleImport(String var1);

        public void startRule();

        public void endRule();

        public void handleSelector(String var1);

        public void handleProperty(String var1);

        public void handleValue(String var1);
    }
}

