#!/bin/sh
export PATH='/usr/obj/ports/hs-vector-0.11.0.0/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: vector
version: 0.11.0.0
id: vector-0.11.0.0-038317210aedffb94db1b450a91d7de1
key: vecto_LmZ3LQW4ivu8MsQuVgukln
license: BSD3
copyright: (c) Roman Leshchinskiy 2008-2012
maintainer: Haskell Libraries Team <libraries@haskell.org>
homepage: https://github.com/haskell/vector
synopsis: Efficient Arrays
description:
    .
    An efficient implementation of Int-indexed arrays (both mutable
    and immutable), with a powerful loop optimisation framework .
    .
    It is structured as follows:
    .
    ["Data.Vector"] Boxed vectors of arbitrary types.
    .
    ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
    representation based on data type families.
    .
    ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.
    .
    ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
    defined by the @primitive@ package. "Data.Vector.Unboxed" is more
    flexible at no performance cost.
    .
    ["Data.Vector.Generic"] Generic interface to the vector types.
    .
    There is also a (draft) tutorial on common uses of vector.
    .
    * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>
category: Data, Data Structures
author: Roman Leshchinskiy <rl@cse.unsw.edu.au>
exposed: True
exposed-modules:
    Data.Vector.Internal.Check Data.Vector.Fusion.Util
    Data.Vector.Fusion.Stream.Monadic Data.Vector.Fusion.Bundle.Size
    Data.Vector.Fusion.Bundle.Monadic Data.Vector.Fusion.Bundle
    Data.Vector.Generic.Mutable.Base Data.Vector.Generic.Mutable
    Data.Vector.Generic.Base Data.Vector.Generic.New
    Data.Vector.Generic Data.Vector.Primitive.Mutable
    Data.Vector.Primitive Data.Vector.Storable.Internal
    Data.Vector.Storable.Mutable Data.Vector.Storable
    Data.Vector.Unboxed.Base Data.Vector.Unboxed.Mutable
    Data.Vector.Unboxed Data.Vector.Mutable Data.Vector
trusted: False
import-dirs: /usr/local/lib/ghc/vector-0.11.0.0
library-dirs: /usr/local/lib/ghc/vector-0.11.0.0
data-dir: /usr/local/share/hs-vector-0.11.0.0
hs-libraries: HSvector-0.11.0.0-LmZ3LQW4ivu8MsQuVgukln
include-dirs: /usr/local/lib/ghc/vector-0.11.0.0/include
depends:
    base-4.8.2.0-6d41353bf1900ecbb9b02a306c286c36
    deepseq-1.4.1.1-7c4279727854e7903ef5ae9e7eb525a5
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    primitive-0.6.1.0-f38df149e24cdcf064227b7cfdaf0f55
haddock-interfaces: /usr/local/share/doc/hs-vector-0.11.0.0/html/vector.haddock
haddock-html: /usr/local/share/doc/hs-vector-0.11.0.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
