/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.cache.LruCacheException;
import net.sourceforge.jnlp.config.InfrastructureFileDescriptor;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.PropertiesFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public class CacheLRUWrapper {
    private final InfrastructureFileDescriptor recentlyUsedPropertiesFile;
    private final InfrastructureFileDescriptor cacheDir;
    private PropertiesFile cachedRecentlyUsedPropertiesFile = null;

    public CacheLRUWrapper() {
        this(PathsAndFiles.getRecentlyUsedFile(), PathsAndFiles.CACHE_DIR);
    }

    public CacheLRUWrapper(InfrastructureFileDescriptor recentlyUsed, InfrastructureFileDescriptor cacheDir) {
        this.recentlyUsedPropertiesFile = recentlyUsed;
        this.cacheDir = cacheDir;
        if (!recentlyUsed.getFile().exists()) {
            try {
                FileUtils.createParentDir(recentlyUsed.getFile());
                FileUtils.createRestrictedFile(recentlyUsed.getFile(), true);
            }
            catch (IOException e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            }
        }
    }

    public static CacheLRUWrapper getInstance() {
        return CacheLRUWrapperHolder.INSTANCE;
    }

    synchronized PropertiesFile getRecentlyUsedPropertiesFile() {
        if (this.cachedRecentlyUsedPropertiesFile == null) {
            this.cachedRecentlyUsedPropertiesFile = new PropertiesFile(this.recentlyUsedPropertiesFile.getFile());
            return this.cachedRecentlyUsedPropertiesFile;
        }
        if (this.recentlyUsedPropertiesFile.getFile().equals(this.cachedRecentlyUsedPropertiesFile.getStoreFile())) {
            return this.cachedRecentlyUsedPropertiesFile;
        }
        if (this.cachedRecentlyUsedPropertiesFile.tryLock()) {
            this.cachedRecentlyUsedPropertiesFile.store();
            this.cachedRecentlyUsedPropertiesFile.unlock();
        }
        this.cachedRecentlyUsedPropertiesFile = new PropertiesFile(this.recentlyUsedPropertiesFile.getFile());
        return this.cachedRecentlyUsedPropertiesFile;
    }

    public InfrastructureFileDescriptor getCacheDir() {
        return this.cacheDir;
    }

    public InfrastructureFileDescriptor getRecentlyUsedFile() {
        return this.recentlyUsedPropertiesFile;
    }

    public synchronized void load() {
        boolean loaded = this.getRecentlyUsedPropertiesFile().load();
        if (loaded && this.checkData()) {
            OutputController.getLogger().log(new LruCacheException());
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CFakeCache"));
            this.store();
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("CFakedCache"));
        }
    }

    private boolean checkData() {
        boolean modified = false;
        Set<Map.Entry<Object, Object>> q = this.getRecentlyUsedPropertiesFile().entrySet();
        Iterator<Map.Entry<Object, Object>> it = q.iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> currentEntry = it.next();
            String key = (String)currentEntry.getKey();
            String path = (String)currentEntry.getValue();
            try {
                String[] sa = key.split(",");
                Long l1 = Long.parseLong(sa[0]);
                Long l = Long.parseLong(sa[1]);
            }
            catch (Exception ex) {
                it.remove();
                modified = true;
                continue;
            }
            if (path != null) {
                if (path.contains(this.getCacheDir().getFullPath())) continue;
                it.remove();
                modified = true;
                continue;
            }
            it.remove();
            modified = true;
        }
        return modified;
    }

    public synchronized boolean store() {
        if (this.getRecentlyUsedPropertiesFile().isHeldByCurrentThread()) {
            this.getRecentlyUsedPropertiesFile().store();
            return true;
        }
        return false;
    }

    public synchronized boolean addEntry(String key, String path) {
        PropertiesFile props = this.getRecentlyUsedPropertiesFile();
        if (props.containsKey(key)) {
            return false;
        }
        props.setProperty(key, path);
        return true;
    }

    public synchronized boolean removeEntry(String key) {
        PropertiesFile props = this.getRecentlyUsedPropertiesFile();
        if (!props.containsKey(key)) {
            return false;
        }
        props.remove(key);
        return true;
    }

    private String getIdForCacheFolder(String folder) {
        int len = this.getCacheDir().getFullPath().length();
        int index = folder.indexOf(File.separatorChar, len + 1);
        return folder.substring(len + 1, index);
    }

    public synchronized boolean updateEntry(String oldKey) {
        PropertiesFile props = this.getRecentlyUsedPropertiesFile();
        if (!props.containsKey(oldKey)) {
            return false;
        }
        String value = props.getProperty(oldKey);
        String folder = this.getIdForCacheFolder(value);
        props.remove(oldKey);
        props.setProperty(Long.toString(System.currentTimeMillis()) + "," + folder, value);
        return true;
    }

    public synchronized List<Map.Entry<String, String>> getLRUSortedEntries() {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<Object, Object> e : this.getRecentlyUsedPropertiesFile().entrySet()) {
            entries.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(e));
        }
        Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                Long t2;
                Long t1 = Long.parseLong(e1.getKey().split(",")[0]);
                int c = t1.compareTo(t2 = Long.valueOf(Long.parseLong(e2.getKey().split(",")[0])));
                return c < 0 ? 1 : (c > 0 ? -1 : 0);
            }
        });
        return entries;
    }

    public synchronized void lock() {
        this.getRecentlyUsedPropertiesFile().lock();
    }

    public synchronized void unlock() {
        this.getRecentlyUsedPropertiesFile().unlock();
    }

    public synchronized String getValue(String key) {
        return this.getRecentlyUsedPropertiesFile().getProperty(key);
    }

    public synchronized boolean containsKey(String key) {
        return this.getRecentlyUsedPropertiesFile().containsKey(key);
    }

    public synchronized boolean containsValue(String value) {
        return this.getRecentlyUsedPropertiesFile().containsValue(value);
    }

    public String generateKey(String path) {
        return System.currentTimeMillis() + "," + this.getIdForCacheFolder(path);
    }

    void clearLRUSortedEntries() {
        this.getRecentlyUsedPropertiesFile().clear();
    }

    private static class CacheLRUWrapperHolder {
        private static final CacheLRUWrapper INSTANCE = new CacheLRUWrapper();

        private CacheLRUWrapperHolder() {
        }
    }
}

