/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.gui.datatransfer.PrimitiveTransferable;
import org.openstreetmap.josm.gui.datatransfer.RelationMemberTransferable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

class MemberTransferHandler
extends TransferHandler {
    MemberTransferHandler() {
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        MemberTable memberTable = (MemberTable)jComponent;
        return new RelationMemberTransferable(memberTable.getMemberTableModel().getSelectedMembers());
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        transferSupport.setShowDropLocation(true);
        return transferSupport.isDataFlavorSupported(RelationMemberTransferable.RELATION_MEMBER_DATA) || transferSupport.isDataFlavorSupported(PrimitiveTransferable.PRIMITIVE_DATA);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        MemberTable memberTable = (MemberTable)transferSupport.getComponent();
        int n = ((JTable.DropLocation)transferSupport.getDropLocation()).getRow();
        try {
            if (transferSupport.isDataFlavorSupported(RelationMemberTransferable.RELATION_MEMBER_DATA)) {
                this.importRelationMemberData(transferSupport, memberTable, n);
            } else if (transferSupport.isDataFlavorSupported(PrimitiveTransferable.PRIMITIVE_DATA)) {
                this.importPrimitiveData(transferSupport, memberTable, n);
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            Main.warn(exception);
            return false;
        }
        return true;
    }

    protected void importRelationMemberData(TransferHandler.TransferSupport transferSupport, final MemberTable memberTable, int n) throws UnsupportedFlavorException, IOException {
        RelationMemberTransferable.Data data = (RelationMemberTransferable.Data)transferSupport.getTransferable().getTransferData(RelationMemberTransferable.RELATION_MEMBER_DATA);
        this.importData(memberTable, n, data.getRelationMemberData(), new Utils.Function<RelationMemberData, RelationMember>(){

            @Override
            public RelationMember apply(RelationMemberData relationMemberData) {
                OsmPrimitive osmPrimitive = memberTable.getLayer().data.getPrimitiveById(relationMemberData.getUniqueId(), relationMemberData.getType());
                if (osmPrimitive == null) {
                    Main.warn(I18n.tr("Cannot add {0} since it is not part of dataset", relationMemberData));
                    return null;
                }
                return new RelationMember(relationMemberData.getRole(), osmPrimitive);
            }
        });
    }

    protected void importPrimitiveData(TransferHandler.TransferSupport transferSupport, final MemberTable memberTable, int n) throws UnsupportedFlavorException, IOException {
        PrimitiveTransferable.Data data = (PrimitiveTransferable.Data)transferSupport.getTransferable().getTransferData(PrimitiveTransferable.PRIMITIVE_DATA);
        this.importData(memberTable, n, data.getPrimitiveData(), new Utils.Function<PrimitiveData, RelationMember>(){

            @Override
            public RelationMember apply(PrimitiveData primitiveData) {
                OsmPrimitive osmPrimitive = memberTable.getLayer().data.getPrimitiveById(primitiveData);
                if (osmPrimitive == null) {
                    Main.warn(I18n.tr("Cannot add {0} since it is not part of dataset", primitiveData));
                    return null;
                }
                return memberTable.getMemberTableModel().getRelationMemberForPrimitive(osmPrimitive);
            }
        });
    }

    protected <T> void importData(MemberTable memberTable, int n, Collection<T> collection, Utils.Function<T, RelationMember> function) {
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>(collection.size());
        for (T t : collection) {
            RelationMember relationMember = function.apply(t);
            if (relationMember == null) continue;
            arrayList.add(relationMember);
        }
        memberTable.getMemberTableModel().addMembersAtIndexKeepingOldSelection(arrayList, n);
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n != 2) {
            return;
        }
        MemberTable memberTable = (MemberTable)jComponent;
        MemberTableModel memberTableModel = memberTable.getMemberTableModel();
        memberTableModel.remove(memberTable.getSelectedRows());
        memberTableModel.selectionChanged(null);
    }
}

