/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class EvenFunction
implements Function {
    private static final long serialVersionUID = 2587673708222713810L;

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        Number result = context.getTypeRegistry().convertToNumber(type1, value1);
        BigDecimal ret = EvenFunction.compute(result);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, ret);
    }

    private static BigDecimal compute(Number result) {
        int intValue = result.doubleValue() < 0.0 ? (int)Math.floor(result.doubleValue()) : (int)Math.ceil(result.doubleValue());
        BigDecimal ret = intValue % 2 == 0 ? (intValue == 0 ? (result.doubleValue() < 0.0 ? new BigDecimal(-2) : (result.doubleValue() > 0.0 ? new BigDecimal(2) : new BigDecimal(0))) : new BigDecimal(intValue)) : (result.doubleValue() < 0.0 ? new BigDecimal(intValue - 1) : new BigDecimal(intValue + 1));
        return ret;
    }

    public String getCanonicalName() {
        return "EVEN";
    }
}

