/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.spreadsheet.common;

import com.projity.graphic.configuration.shape.Colors;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.SpreadSheetPopupMenu;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheet;
import com.projity.pm.graphic.spreadsheet.common.CommonSpreadSheetModel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableColumnModel;

public class SpreadSheetRowHeader
extends JTable {
    protected CommonSpreadSheet table;

    public SpreadSheetRowHeader(CommonSpreadSheet commonSpreadSheet) {
        this.setGridColor(Colors.GRAY);
        this.table = commonSpreadSheet;
        if (commonSpreadSheet instanceof SpreadSheet) {
            final SpreadSheet spreadSheet = (SpreadSheet)commonSpreadSheet;
            this.getActionMap().put("cut", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    spreadSheet.prepareAction("Cut").actionPerformed(new ActionEvent(spreadSheet, actionEvent.getID(), actionEvent.getActionCommand()));
                }
            });
            this.getActionMap().put("copy", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    spreadSheet.prepareAction("Copy").actionPerformed(new ActionEvent(spreadSheet, actionEvent.getID(), actionEvent.getActionCommand()));
                }
            });
            this.getActionMap().put("paste", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    spreadSheet.prepareAction("Paste").actionPerformed(new ActionEvent(spreadSheet, actionEvent.getID(), actionEvent.getActionCommand()));
                }
            });
        }
        this.setUI(new BasicTableUI());
    }

    protected SpreadSheetPopupMenu getPopup() {
        return ((SpreadSheet)this.table).getPopup();
    }

    public void setModel(CommonSpreadSheetModel commonSpreadSheetModel, DefaultTableColumnModel defaultTableColumnModel) {
        this.setModel(commonSpreadSheetModel);
        this.setColumnModel(defaultTableColumnModel);
        this.setAutoResizeMode(0);
        if (this.table instanceof SpreadSheet) {
            SpreadSheet spreadSheet = (SpreadSheet)this.table;
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    SpreadSheetPopupMenu spreadSheetPopupMenu = SpreadSheetRowHeader.this.getPopup();
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        if (mouseEvent.getClickCount() == 2) {
                            ((SpreadSheet)SpreadSheetRowHeader.this.table).doDoubleClick(0, 0);
                        }
                    } else if (spreadSheetPopupMenu != null && SwingUtilities.isRightMouseButton(mouseEvent)) {
                        Point point = mouseEvent.getPoint();
                        int n = SpreadSheetRowHeader.this.rowAtPoint(point);
                        int n2 = SpreadSheetRowHeader.this.columnAtPoint(point);
                        SpreadSheetRowHeader.this.table.selection.getRowSelection().addSelectionInterval(n, n);
                        spreadSheetPopupMenu.setRow(n);
                        spreadSheetPopupMenu.setCol(0);
                        spreadSheetPopupMenu.show(SpreadSheetRowHeader.this, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        this.changeSelection(n, n2, bl, bl2, true);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.getSelectedRowCount() == 0;
        super.changeSelection(n, n2, bl, bl2);
        if (bl3) {
            this.table.finishCurrentOperations();
            if (bl4) {
                this.table.changeSelection(n, n2, false, false, false);
            } else {
                this.table.changeSelection(n, n2, bl, bl2, false);
            }
            this.table.getSelection().getColumnSelection().addSelectionInterval(0, this.table.getColumnCount() - 1);
        }
    }

    public CommonSpreadSheet getSpreadSheet() {
        return this.table;
    }

    public void updateUI() {
        this.setUI(new BasicTableUI());
    }
}

