/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableEditor
extends FieldEditor {
    private Table table;
    private Composite buttonBox;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener selectionListener;
    private TableColumn col1;
    private TableColumn col2;

    protected abstract String createTable(List<String[]> var1);

    protected abstract String[] getNewInputObject();

    protected abstract List<String[]> parseString(String var1);

    protected TableEditor() {
    }

    protected TableEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String[] input = this.getNewInputObject();
        if (input != null) {
            int index = this.table.getSelectionIndex();
            TableItem tableItem = index >= 0 ? new TableItem(this.table, 0, index + 1) : new TableItem(this.table, 0);
            tableItem.setText(input);
            this.selectionChanged();
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "Add");
        this.removeButton = this.createPushButton(box, "Remove");
        this.upButton = this.createPushButton(box, "Up");
        this.downButton = this.createPushButton(box, "Down");
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(key);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == TableEditor.this.addButton) {
                    TableEditor.this.addPressed();
                } else if (widget == TableEditor.this.removeButton) {
                    TableEditor.this.removePressed();
                } else if (widget == TableEditor.this.upButton) {
                    TableEditor.this.upPressed();
                } else if (widget == TableEditor.this.downButton) {
                    TableEditor.this.downPressed();
                } else if (widget == TableEditor.this.table) {
                    TableEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.table = this.getTableControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.table != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            List<String[]> array = this.parseString(s);
            for (String[] data : array) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(data);
            }
        }
    }

    protected void doLoadDefault() {
        if (this.table != null) {
            this.table.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            List<String[]> array = this.parseString(s);
            for (String[] tup : array) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(tup);
            }
        }
    }

    protected void doStore() {
        TableItem[] items = this.table.getItems();
        ArrayList<String[]> list = new ArrayList<String[]>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            list.add(new String[]{tableItem.getText(0), tableItem.getText(1)});
            ++n2;
        }
        String s = this.createTable(list);
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    private void downPressed() {
        this.swap(false);
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TableEditor.this.addButton = null;
                    TableEditor.this.removeButton = null;
                    TableEditor.this.upButton = null;
                    TableEditor.this.downButton = null;
                    TableEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public Table getTableControl(Composite parent) {
        if (this.table == null) {
            this.table = new Table(parent, 68356);
            this.table.setHeaderVisible(true);
            this.col1 = new TableColumn(this.table, 16384);
            this.col1.setText("Path to translate");
            this.col1.setWidth(200);
            this.col2 = new TableColumn(this.table, 16384);
            this.col2.setText("Translated path");
            this.col2.setWidth(200);
            this.table.setFont(parent.getFont());
            this.table.addSelectionListener(this.getSelectionListener());
            this.table.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TableEditor.this.col1 = null;
                    TableEditor.this.col2 = null;
                    TableEditor.this.table = null;
                }
            });
        } else {
            this.checkParent((Control)this.table, parent);
        }
        return this.table;
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            this.table.remove(index);
            this.selectionChanged();
        }
    }

    private void selectionChanged() {
        int index = this.table.getSelectionIndex();
        int size = this.table.getItemCount();
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            TableItem targetItem = this.table.getItem(target);
            TableItem sourceItem = this.table.getItem(index);
            String[] targetContents = new String[]{targetItem.getText(0), targetItem.getText(1)};
            String[] sourceContents = new String[]{sourceItem.getText(0), sourceItem.getText(1)};
            targetItem.setText(sourceContents);
            sourceItem.setText(targetContents);
            this.table.setSelection(target);
        }
        this.selectionChanged();
    }

    private void upPressed() {
        this.swap(true);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTableControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }
}

