/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.sprm;

import org.apache.poi.util.BitField;
import org.apache.poi.util.LittleEndian;

public class SprmOperation {
    private static final BitField OP_BITFIELD = new BitField(511);
    private static final BitField SPECIAL_BITFIELD = new BitField(512);
    private static final BitField TYPE_BITFIELD = new BitField(7168);
    private static final BitField SIZECODE_BITFIELD = new BitField(57344);
    private static final short LONG_SPRM_TABLE = -10744;
    private static final short LONG_SPRM_PARAGRAPH = -14827;
    public static final int PAP_TYPE = 1;
    public static final int TAP_TYPE = 5;
    private int _type;
    private int _operation;
    private int _gOffset;
    private byte[] _grpprl;
    private int _sizeCode;
    private int _size;

    public SprmOperation(byte[] byArray, int n) {
        this._grpprl = byArray;
        short s = LittleEndian.getShort(byArray, n);
        this._gOffset = n + 2;
        this._operation = OP_BITFIELD.getValue(s);
        this._type = TYPE_BITFIELD.getValue(s);
        this._sizeCode = SIZECODE_BITFIELD.getValue(s);
        this._size = this.initSize(s);
    }

    public int getType() {
        return this._type;
    }

    public int getOperation() {
        return this._operation;
    }

    public int getGrpprlOffset() {
        return this._gOffset;
    }

    public int getOperand() {
        switch (this._sizeCode) {
            case 0: 
            case 1: {
                return this._grpprl[this._gOffset];
            }
            case 2: 
            case 4: 
            case 5: {
                return LittleEndian.getShort(this._grpprl, this._gOffset);
            }
            case 3: {
                return LittleEndian.getInt(this._grpprl, this._gOffset);
            }
            case 6: {
                throw new UnsupportedOperationException("This SPRM contains a variable length operand");
            }
            case 7: {
                byte[] byArray = new byte[]{this._grpprl[this._gOffset], this._grpprl[this._gOffset + 1], this._grpprl[this._gOffset + 2], 0};
                return LittleEndian.getInt(byArray, 0);
            }
        }
        throw new IllegalArgumentException("SPRM contains an invalid size code");
    }

    public int getSizeCode() {
        return this._sizeCode;
    }

    public int size() {
        return this._size;
    }

    public byte[] getGrpprl() {
        return this._grpprl;
    }

    private int initSize(short s) {
        switch (this._sizeCode) {
            case 0: 
            case 1: {
                return 3;
            }
            case 2: 
            case 4: 
            case 5: {
                return 4;
            }
            case 3: {
                return 6;
            }
            case 6: {
                if (s == -10744 || s == -14827) {
                    int n = (0xFFFF & LittleEndian.getShort(this._grpprl, this._gOffset)) + 3;
                    this._gOffset += 2;
                    return n;
                }
                return (0xFF & this._grpprl[this._gOffset++]) + 3;
            }
            case 7: {
                return 5;
            }
        }
        throw new IllegalArgumentException("SPRM contains an invalid size code");
    }
}

