/*
 * Decompiled with CFR 0.152.
 */
package tr.data;

import java.awt.Frame;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;
import tr.background.activation.ActivatorTaskScheduler;
import tr.background.recurrence.RecurrenceTaskScheduler;
import tr.data.DAOProvider;
import tr.data.DAOProviderLookup;
import tr.data.FileFilterImpl;
import tr.datastore.DataStore;
import tr.datastore.DataStoreLookup;
import tr.datastore.xstream.XStreamDataStore;
import tr.view.WindowUtils;

public final class OpenAction
extends CallableSystemAction {
    private static final Logger LOG = Logger.getLogger("tr.data");

    protected String iconResource() {
        return "au/com/thinkingrock/tr/resource/icons/DataOpen.png";
    }

    public void performAction() {
        Frame p;
        int returnVal;
        DataStore ds = (DataStore)DataStoreLookup.instance().lookup(DataStore.class);
        if (ds == null) {
            LOG.severe("Datastore was not found.");
            return;
        }
        JFileChooser chooser = new JFileChooser();
        String[] extns = XStreamDataStore.FILE_EXTENSIONS;
        FileFilterImpl filter = new FileFilterImpl(NbBundle.getMessage(OpenAction.class, (String)"tr.xstream.datafiles"), extns, true);
        chooser.setFileFilter(filter);
        File defaultFile = new File(ds.getPath());
        if (defaultFile.exists()) {
            chooser.setSelectedFile(defaultFile);
        }
        if ((returnVal = chooser.showOpenDialog(p = WindowManager.getDefault().getMainWindow())) != 0) {
            return;
        }
        try {
            ds.store();
        }
        catch (Exception ex) {
            // empty catch block
        }
        WindowUtils.closeWindows();
        DAOProvider screensDAOProvider = (DAOProvider)DAOProviderLookup.instance().lookup(DAOProvider.class);
        if (screensDAOProvider != null) {
            try {
                LOG.info("Saving actions screens.");
                if (screensDAOProvider.isInitialised()) {
                    screensDAOProvider.provide().persist();
                    screensDAOProvider.provide().reset();
                    screensDAOProvider.reset();
                }
            }
            catch (Exception ex) {
                LOG.severe("Review Actions screens could not be saved. " + ex.getMessage());
            }
        }
        try {
            String path = chooser.getSelectedFile().getPath();
            ds.setPath(path);
            ds.load();
            WindowManager.getDefault().getMainWindow().setTitle("ThinkingRock " + path);
            WindowUtils.closeWindows();
            WindowUtils.openInitialWindow();
            ActivatorTaskScheduler.instance().runTask(0, 1, 0);
            RecurrenceTaskScheduler.instance().runTask(0, 2, 0);
        }
        catch (Exception ex) {
            String t = NbBundle.getMessage(OpenAction.class, (String)"file.open.error.title");
            String m = NbBundle.getMessage(OpenAction.class, (String)"file.open.error.message") + "\n" + ex.getMessage();
            JOptionPane.showMessageDialog(p, m, t, 0);
            ex.printStackTrace(System.err);
        }
    }

    public String getName() {
        return NbBundle.getMessage(OpenAction.class, (String)"CTL_OpenAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

