/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.manualrequest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.manualrequest.MessageSender;
import org.parosproxy.paros.view.AbstractFrame;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.tab.Tab;
import org.zaproxy.zap.view.ZapMenuItem;

public abstract class ManualRequestEditorDialog
extends AbstractFrame
implements Tab {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ManualRequestEditorDialog.class);
    private boolean isSendEnabled = true;
    protected String configurationKey;
    private JPanel panelWindow = null;
    private JButton btnSend = null;

    public ManualRequestEditorDialog(boolean bl, String string) throws HeadlessException {
        this.isSendEnabled = bl;
        this.configurationKey = "view." + string + ".";
        this.setPreferredSize(new Dimension(700, 800));
    }

    protected void initialize() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ManualRequestEditorDialog.this.getMessageSender().cleanup();
                ManualRequestEditorDialog.this.saveConfig();
            }
        });
        this.setContentPane(this.getWindowPanel());
    }

    public abstract Class<? extends Message> getMessageType();

    protected abstract MessageSender getMessageSender();

    public abstract ZapMenuItem getMenuItem();

    protected JPanel getWindowPanel() {
        if (this.panelWindow == null) {
            this.panelWindow = new JPanel();
            this.panelWindow.setLayout(new BorderLayout());
            this.panelWindow.add(this.getManualSendPanel());
        }
        return this.panelWindow;
    }

    protected abstract Component getManualSendPanel();

    @Override
    public void setVisible(boolean bl) {
        if (!bl && this.getMessageSender() != null) {
            this.getMessageSender().cleanup();
        }
        super.setVisible(bl);
    }

    public abstract void setDefaultMessage();

    public abstract void setMessage(Message var1);

    public abstract Message getMessage();

    public void clear() {
        this.getRequestPanel().clearView();
    }

    protected JButton getBtnSend() {
        if (this.btnSend == null) {
            this.btnSend = new JButton();
            this.btnSend.setText(Constant.messages.getString("manReq.button.send"));
            this.btnSend.setEnabled(this.isSendEnabled);
            this.btnSend.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManualRequestEditorDialog.this.btnSend.setEnabled(false);
                    ManualRequestEditorDialog.this.getRequestPanel().saveData();
                    Control.Mode mode = Control.getSingleton().getMode();
                    if (mode.equals((Object)Control.Mode.safe)) {
                        View.getSingleton().showWarningDialog(Constant.messages.getString("manReq.safe.warning"));
                        ManualRequestEditorDialog.this.btnSend.setEnabled(true);
                        return;
                    }
                    if (mode.equals((Object)Control.Mode.protect) && !ManualRequestEditorDialog.this.getMessage().isInScope()) {
                        View.getSingleton().showWarningDialog(Constant.messages.getString("manReq.outofscope.warning"));
                        ManualRequestEditorDialog.this.btnSend.setEnabled(true);
                        return;
                    }
                    ManualRequestEditorDialog.this.btnSendAction();
                }
            });
        }
        return this.btnSend;
    }

    protected abstract void btnSendAction();

    protected void send(final Message message) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ManualRequestEditorDialog.this.getMessageSender().handleSendMessage(message);
                    ManualRequestEditorDialog.this.postSend();
                }
                catch (Exception exception) {
                    logger.warn((Object)exception.getMessage(), (Throwable)exception);
                    View.getSingleton().showWarningDialog(exception.getMessage());
                }
                finally {
                    ManualRequestEditorDialog.this.btnSend.setEnabled(true);
                }
            }
        });
        thread.setPriority(5);
        thread.start();
    }

    protected void postSend() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ManualRequestEditorDialog.this.getRequestPanel().updateContent();
            }
        });
    }

    protected abstract void saveConfig();

    protected abstract HttpPanelRequest getRequestPanel();
}

