/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ExtensionPopupMenu;
import org.zaproxy.zap.extension.history.PopupMenuPurgeSites;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;
import org.zaproxy.zap.view.popup.PopupMenuUtils;

public class MainPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -3021348328961418293L;
    private List<JMenuItem> itemList = null;
    private PopupMenuPurgeSites popupMenuPurgeSites = null;
    Map<String, JMenu> superMenus = new HashMap<String, JMenu>();
    View view = null;
    private static Logger log = Logger.getLogger(MainPopupMenu.class);
    private MenuSelectionChangeListener menuSelectionChangeListener;
    private MenuElement[] pathSelectedMenu;

    public MainPopupMenu(View view) {
        this.initialize();
        this.view = view;
    }

    public MainPopupMenu(String string, View view) {
        super(string);
        this.view = view;
    }

    public MainPopupMenu(List<JMenuItem> list, View view) {
        this(view);
        this.itemList = list;
    }

    private void initialize() {
        this.add(this.getPopupMenuPurgeSites());
        this.menuSelectionChangeListener = new MenuSelectionChangeListener();
        this.addPopupMenuListener(new MenuSelectionListenerInstaller());
    }

    public void show(MessageContainer<?> messageContainer, int n, int n2) {
        this.showImpl(PopupMenuUtils.getPopupMenuInvokerWrapper(messageContainer), n, n2);
    }

    @Override
    public synchronized void show(Component component, int n, int n2) {
        this.showImpl(PopupMenuUtils.getPopupMenuInvokerWrapper(component), n, n2);
    }

    private synchronized void showImpl(PopupMenuUtils.PopupMenuInvokerWrapper popupMenuInvokerWrapper, int n, int n2) {
        JMenuItem jMenuItem;
        Component component;
        int n3;
        for (n3 = 0; n3 < this.getComponentCount(); ++n3) {
            component = this.getComponent(n3);
            try {
                if (component == null || !(component instanceof ExtensionPopupMenuItem)) continue;
                jMenuItem = (ExtensionPopupMenuItem)component;
                jMenuItem.setVisible(popupMenuInvokerWrapper.isEnable((ExtensionPopupMenuComponent)((Object)jMenuItem)));
                if (!Control.getSingleton().getMode().equals((Object)Control.Mode.safe) || ((ExtensionPopupMenuItem)jMenuItem).isSafe()) continue;
                jMenuItem.setEnabled(false);
                continue;
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        for (n3 = 0; n3 < this.itemList.size(); ++n3) {
            component = this.itemList.get(n3);
            if (component instanceof ExtensionPopupMenuItem) {
                this.handleMenuItem(popupMenuInvokerWrapper, (ExtensionPopupMenuItem)component);
                continue;
            }
            if (!(component instanceof ExtensionPopupMenu)) continue;
            jMenuItem = (ExtensionPopupMenu)component;
            MainPopupMenu.prepareShow((ExtensionPopupMenu)jMenuItem);
            this.handleMenu(popupMenuInvokerWrapper, (ExtensionPopupMenu)jMenuItem);
        }
        PopupMenuUtils.removeTopAndBottomSeparators(this);
        if (PopupMenuUtils.isAtLeastOneChildComponentVisible(this)) {
            super.show(popupMenuInvokerWrapper.getComponent(), n, n2);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            ExtensionPopupMenuComponent extensionPopupMenuComponent = null;
            if (this.pathSelectedMenu != null) {
                MenuElement menuElement = this.pathSelectedMenu[this.pathSelectedMenu.length - 1];
                if (PopupMenuUtils.isExtensionPopupMenuComponent(menuElement)) {
                    extensionPopupMenuComponent = (ExtensionPopupMenuComponent)((Object)menuElement);
                }
                this.pathSelectedMenu = null;
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!PopupMenuUtils.isExtensionPopupMenuComponent(component)) continue;
                ((ExtensionPopupMenuComponent)((Object)component)).dismissed(extensionPopupMenuComponent);
            }
        }
    }

    private static void prepareShow(ExtensionPopupMenu extensionPopupMenu) {
        extensionPopupMenu.prepareShow();
    }

    private void handleMenuItem(PopupMenuUtils.PopupMenuInvokerWrapper popupMenuInvokerWrapper, ExtensionPopupMenuItem extensionPopupMenuItem) {
        try {
            if (extensionPopupMenuItem == ExtensionHookMenu.POPUP_MENU_SEPARATOR) {
                PopupMenuUtils.addSeparatorIfNeeded(this);
            } else if (popupMenuInvokerWrapper.isEnable(extensionPopupMenuItem)) {
                if (extensionPopupMenuItem.isSubMenu()) {
                    JMenu jMenu = this.getSuperMenu(extensionPopupMenuItem.getParentMenuName(), extensionPopupMenuItem.getParentMenuIndex());
                    if (extensionPopupMenuItem.precedeWithSeparator()) {
                        PopupMenuUtils.addSeparatorIfNeeded(jMenu.getPopupMenu());
                    }
                    if (extensionPopupMenuItem.isDummyItem()) {
                        jMenu.setEnabled(false);
                    } else {
                        jMenu.add(extensionPopupMenuItem);
                        jMenu.setEnabled(true);
                    }
                    if (extensionPopupMenuItem.succeedWithSeparator()) {
                        jMenu.addSeparator();
                    }
                } else {
                    if (extensionPopupMenuItem.precedeWithSeparator()) {
                        PopupMenuUtils.addSeparatorIfNeeded(this);
                    }
                    this.addMenuItem(extensionPopupMenuItem, extensionPopupMenuItem.getMenuIndex());
                    if (extensionPopupMenuItem.succeedWithSeparator()) {
                        this.addSeparator();
                    }
                }
            }
            if (Control.getSingleton().getMode().equals((Object)Control.Mode.safe) && !extensionPopupMenuItem.isSafe()) {
                extensionPopupMenuItem.setEnabled(false);
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private void handleMenu(PopupMenuUtils.PopupMenuInvokerWrapper popupMenuInvokerWrapper, ExtensionPopupMenu extensionPopupMenu) {
        try {
            if (popupMenuInvokerWrapper.isEnable(extensionPopupMenu)) {
                if (extensionPopupMenu.isSubMenu()) {
                    JMenu jMenu = this.getSuperMenu(extensionPopupMenu.getParentMenuName(), extensionPopupMenu.getParentMenuIndex());
                    if (extensionPopupMenu.precedeWithSeparator()) {
                        PopupMenuUtils.addSeparatorIfNeeded(jMenu.getPopupMenu());
                    }
                    jMenu.add(extensionPopupMenu);
                    if (extensionPopupMenu.succeedWithSeparator()) {
                        jMenu.addSeparator();
                    }
                } else {
                    if (extensionPopupMenu.precedeWithSeparator()) {
                        PopupMenuUtils.addSeparatorIfNeeded(this);
                    }
                    this.addMenuItem(extensionPopupMenu, extensionPopupMenu.getMenuIndex());
                    if (extensionPopupMenu.succeedWithSeparator()) {
                        this.addSeparator();
                    }
                }
                if (Control.getSingleton().getMode().equals((Object)Control.Mode.safe) && !extensionPopupMenu.isSafe()) {
                    extensionPopupMenu.setEnabled(false);
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private JMenu getSuperMenu(String string, int n) {
        JMenu jMenu = this.superMenus.get(string);
        if (jMenu == null) {
            jMenu = new ExtensionPopupMenu(string){
                private static final long serialVersionUID = 6825880451078204378L;

                @Override
                public boolean isEnableForComponent(Component component) {
                    return true;
                }
            };
            this.superMenus.put(string, jMenu);
            this.addMenuItem(jMenu, n);
        }
        return jMenu;
    }

    private void addMenuItem(JMenuItem jMenuItem, int n) {
        int n2 = n < 0 && n != -1 || n > this.getComponentCount() ? -1 : n;
        this.add((Component)jMenuItem, n2);
    }

    private PopupMenuPurgeSites getPopupMenuPurgeSites() {
        if (this.popupMenuPurgeSites == null) {
            this.popupMenuPurgeSites = new PopupMenuPurgeSites();
        }
        return this.popupMenuPurgeSites;
    }

    public void addMenu(ExtensionPopupMenuItem extensionPopupMenuItem) {
        this.itemList.add(extensionPopupMenuItem);
    }

    public void removeMenu(ExtensionPopupMenuItem extensionPopupMenuItem) {
        this.itemList.remove(extensionPopupMenuItem);
    }

    public void addMenu(ExtensionPopupMenu extensionPopupMenu) {
        this.itemList.add(extensionPopupMenu);
    }

    public void removeMenu(ExtensionPopupMenu extensionPopupMenu) {
        this.itemList.remove(extensionPopupMenu);
    }

    static /* synthetic */ MenuElement[] access$202(MainPopupMenu mainPopupMenu, MenuElement[] menuElementArray) {
        mainPopupMenu.pathSelectedMenu = menuElementArray;
        return menuElementArray;
    }

    private class MenuSelectionListenerInstaller
    implements PopupMenuListener {
        private MenuSelectionListenerInstaller() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            MenuSelectionManager.defaultManager().addChangeListener(MainPopupMenu.this.menuSelectionChangeListener);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            MenuSelectionManager.defaultManager().removeChangeListener(MainPopupMenu.this.menuSelectionChangeListener);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            MainPopupMenu.access$202(MainPopupMenu.this, null);
        }
    }

    private class MenuSelectionChangeListener
    implements ChangeListener {
        private MenuSelectionChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            MainPopupMenu.access$202(MainPopupMenu.this, MenuSelectionManager.defaultManager().getSelectedPath());
        }
    }
}

