/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.zaproxy.zap.utils.ZapXmlConfiguration;

public class ScanPolicy {
    private String name;
    private PluginFactory pluginFactory = new PluginFactory();
    private Plugin.AlertThreshold defaultThreshold;
    private Plugin.AttackStrength defaultStrength;
    private ZapXmlConfiguration conf;

    public ScanPolicy() {
        this.conf = new ZapXmlConfiguration();
        this.name = this.conf.getString("policy", "");
        this.pluginFactory.loadAllPlugin((Configuration)this.conf);
        this.setDefaultThreshold(Plugin.AlertThreshold.MEDIUM);
        this.setDefaultStrength(Plugin.AttackStrength.MEDIUM);
    }

    public ScanPolicy(ZapXmlConfiguration zapXmlConfiguration) throws ConfigurationException {
        this.conf = zapXmlConfiguration;
        this.name = zapXmlConfiguration.getString("policy", "");
        this.pluginFactory.loadAllPlugin((Configuration)zapXmlConfiguration);
        this.setDefaultThreshold(Plugin.AlertThreshold.valueOf(zapXmlConfiguration.getString("scanner.level", Plugin.AlertThreshold.MEDIUM.name())));
        this.setDefaultStrength(Plugin.AttackStrength.valueOf(zapXmlConfiguration.getString("scanner.strength", Plugin.AttackStrength.MEDIUM.name())));
    }

    public ScanPolicy(FileConfiguration fileConfiguration) throws ConfigurationException {
        this.pluginFactory.loadAllPlugin((Configuration)fileConfiguration);
        this.conf = new ZapXmlConfiguration();
        this.name = "";
        this.setDefaultThreshold(Plugin.AlertThreshold.MEDIUM);
        this.setDefaultStrength(Plugin.AttackStrength.MEDIUM);
    }

    public ScanPolicy clonePolicy() throws ConfigurationException {
        return new ScanPolicy((ZapXmlConfiguration)((Object)this.conf.clone()));
    }

    public void cloneInto(ScanPolicy scanPolicy) {
        scanPolicy.pluginFactory.loadFrom(this.pluginFactory);
        scanPolicy.defaultStrength = this.getDefaultStrength();
        scanPolicy.defaultThreshold = this.getDefaultThreshold();
    }

    public String getName() {
        return this.name;
    }

    public PluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public Plugin.AlertThreshold getDefaultThreshold() {
        return this.defaultThreshold;
    }

    public Plugin.AttackStrength getDefaultStrength() {
        return this.defaultStrength;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDefaultThreshold(Plugin.AlertThreshold alertThreshold) {
        this.defaultThreshold = alertThreshold;
        for (Plugin plugin : this.pluginFactory.getAllPlugin()) {
            plugin.setDefaultAlertThreshold(alertThreshold);
        }
    }

    public void setDefaultStrength(Plugin.AttackStrength attackStrength) {
        this.defaultStrength = attackStrength;
        for (Plugin plugin : this.pluginFactory.getAllPlugin()) {
            plugin.setDefaultAttackStrength(attackStrength);
        }
    }

    public void save() throws ConfigurationException {
        this.conf.save();
    }
}

