/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.compare;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.paros.ParosDatabase;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SessionListener;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.DesktopUtils;

public class ExtensionCompare
extends ExtensionAdaptor
implements SessionChangedListener,
SessionListener {
    private static final String CRLF = "\r\n";
    private JMenuItem menuCompare = null;
    private static Logger log = Logger.getLogger(ExtensionCompare.class);

    public ExtensionCompare() {
        this.initialize();
    }

    public ExtensionCompare(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionCompare");
        this.setOrder(44);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addReportMenuItem(this.getMenuCompare());
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionCompare.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception exception) {
                log.warn((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    private JMenuItem getMenuCompare() {
        if (this.menuCompare == null) {
            this.menuCompare = new JMenuItem();
            this.menuCompare.setText(Constant.messages.getString("cmp.file.menu.compare"));
            this.menuCompare.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionCompare.this.compareSessions();
                }
            });
        }
        return this.menuCompare;
    }

    private void buildHistoryMap(TableHistory tableHistory, Map<String, String> map) throws DatabaseException, HttpMalformedHeaderException {
        RecordHistory recordHistory = null;
        for (int i = 0; i < 100 && (recordHistory = tableHistory.read(i)) == null; ++i) {
        }
        if (recordHistory == null) {
            return;
        }
        List<Integer> list = tableHistory.getHistoryIdsOfHistType(recordHistory.getSessionId(), 1, 15);
        for (Integer n : list) {
            RecordHistory recordHistory2 = tableHistory.read(n);
            URI uRI = recordHistory2.getHttpMessage().getRequestHeader().getURI();
            String string = recordHistory2.getHttpMessage().getRequestHeader().getMethod() + " " + uRI.toString();
            if (string.indexOf("?") > -1) {
                string = string.substring(0, string.indexOf("?"));
            }
            String string2 = map.get(string);
            String string3 = recordHistory2.getHttpMessage().getResponseHeader().getStatusCode() + " ";
            if (string2 == null) {
                map.put(string, string3);
                continue;
            }
            if (string2.indexOf(string3) >= 0) continue;
            map.put(string, string2 + string3);
        }
    }

    private void compareSessions() {
        block13: {
            JFileChooser jFileChooser = new JFileChooser(Model.getSingleton().getOptionsParam().getUserDirectory());
            File file = null;
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.isFile() && file.getName().endsWith(".session");
                }

                @Override
                public String getDescription() {
                    return Constant.messages.getString("file.format.zap.session");
                }
            });
            int n = jFileChooser.showOpenDialog(View.getSingleton().getMainFrame());
            if (n == 0) {
                try {
                    file = jFileChooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    Model model = new Model();
                    Session session = model.getSession();
                    model.openSession(file, (SessionListener)this);
                    ParosDatabase parosDatabase = new ParosDatabase();
                    parosDatabase.open(file.getAbsolutePath());
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    HashMap<String, String> hashMap2 = new HashMap<String, String>();
                    this.buildHistoryMap(Model.getSingleton().getDb().getTableHistory(), hashMap);
                    this.buildHistoryMap(parosDatabase.getTableHistory(), hashMap2);
                    File file2 = this.getOutputFile();
                    if (file2 == null) break block13;
                    try {
                        TreeSet treeSet = new TreeSet();
                        treeSet.addAll(hashMap.keySet());
                        treeSet.addAll(hashMap2.keySet());
                        StringBuilder stringBuilder = new StringBuilder(500);
                        stringBuilder.append("<?xml version=\"1.0\"?>");
                        stringBuilder.append(CRLF);
                        stringBuilder.append("<report>");
                        stringBuilder.append(CRLF);
                        stringBuilder.append("<session-names>");
                        stringBuilder.append(CRLF);
                        stringBuilder.append("<session1>");
                        stringBuilder.append(Model.getSingleton().getSession().getSessionName());
                        stringBuilder.append("</session1>");
                        stringBuilder.append(CRLF);
                        stringBuilder.append("<session2>");
                        stringBuilder.append(session.getSessionName());
                        stringBuilder.append("</session2>");
                        stringBuilder.append(CRLF);
                        stringBuilder.append("</session-names>");
                        stringBuilder.append(CRLF);
                        Iterator iterator = treeSet.iterator();
                        while (iterator.hasNext()) {
                            stringBuilder.append("<urlrow>");
                            stringBuilder.append(CRLF);
                            String string = (String)iterator.next();
                            String string2 = string.substring(0, string.indexOf(" "));
                            String string3 = string.substring(string.indexOf(" ") + 1);
                            stringBuilder.append("<method>");
                            stringBuilder.append(string2);
                            stringBuilder.append("</method>");
                            stringBuilder.append(CRLF);
                            stringBuilder.append("<url>");
                            stringBuilder.append(string3);
                            stringBuilder.append("</url>");
                            stringBuilder.append(CRLF);
                            stringBuilder.append("<code1>");
                            if (hashMap.containsKey(string)) {
                                stringBuilder.append((String)hashMap.get(string));
                            } else {
                                stringBuilder.append("---");
                            }
                            stringBuilder.append("</code1>");
                            stringBuilder.append(CRLF);
                            stringBuilder.append("<code2>");
                            if (hashMap2.containsKey(string)) {
                                stringBuilder.append((String)hashMap2.get(string));
                            } else {
                                stringBuilder.append("---");
                            }
                            stringBuilder.append("</code2>");
                            stringBuilder.append(CRLF);
                            stringBuilder.append("</urlrow>");
                            stringBuilder.append(CRLF);
                        }
                        stringBuilder.append("</report>");
                        stringBuilder.append(CRLF);
                        ReportGenerator.stringToHtml(stringBuilder.toString(), Constant.getZapInstall() + File.separator + "xml" + File.separator + "reportCompare.xsl", file2.getAbsolutePath());
                        try {
                            DesktopUtils.openUrlInBrowser(file2.toURI());
                        }
                        catch (Exception exception) {
                            log.error((Object)exception.getMessage(), (Throwable)exception);
                            View.getSingleton().showMessageDialog(MessageFormat.format(Constant.messages.getString("report.complete.warning"), file2.getAbsolutePath()));
                        }
                    }
                    catch (Exception exception) {
                        log.warn((Object)exception.getMessage(), (Throwable)exception);
                    }
                }
                catch (Exception exception) {
                    log.warn((Object)exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    private File getOutputFile() {
        JFileChooser jFileChooser = new JFileChooser(this.getModel().getOptionsParam().getUserDirectory());
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                if (file.isFile() && file.getName().toLowerCase().endsWith(".htm")) {
                    return true;
                }
                return file.isFile() && file.getName().toLowerCase().endsWith(".html");
            }

            @Override
            public String getDescription() {
                return Constant.messages.getString("file.format.html");
            }
        });
        File file = null;
        int n = jFileChooser.showSaveDialog(this.getView().getMainFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.getModel().getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
            String string = file.getAbsolutePath().toLowerCase();
            if (!string.endsWith(".htm") && !string.endsWith(".html")) {
                file = new File(file.getAbsolutePath() + ".html");
            }
            return file;
        }
        return file;
    }

    @Override
    public void sessionOpened(File file, Exception exception) {
    }

    @Override
    public void sessionSaved(Exception exception) {
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("cmp.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Override
    public void sessionSnapshot(Exception exception) {
    }
}

