/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.model;

import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.zaproxy.zap.utils.Enableable;

public class StructuralNodeModifier
extends Enableable
implements Cloneable {
    private static final String CONFIG_NAME = "name";
    private static final String CONFIG_TYPE = "type";
    private static final String CONFIG_PATTERN = "pattern";
    private Type type;
    private Pattern pattern;
    private String name;

    public StructuralNodeModifier(Type type, Pattern pattern, String string) {
        this.type = type;
        this.pattern = pattern;
        this.name = string;
    }

    public StructuralNodeModifier(String string) {
        JSONObject jSONObject = JSONObject.fromObject((Object)string);
        this.name = jSONObject.getString(CONFIG_NAME);
        this.type = Type.valueOf(jSONObject.getString(CONFIG_TYPE));
        if (jSONObject.containsKey((Object)CONFIG_TYPE)) {
            this.pattern = Pattern.compile(jSONObject.getString(CONFIG_PATTERN));
        }
    }

    public Type getType() {
        return this.type;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public StructuralNodeModifier clone() {
        return new StructuralNodeModifier(this.type, Pattern.compile(this.pattern.toString()), this.name);
    }

    public String getConfig() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)CONFIG_TYPE, (Object)this.getType().name());
        jSONObject.put((Object)CONFIG_NAME, (Object)this.getName());
        if (this.getPattern() != null) {
            jSONObject.put((Object)CONFIG_PATTERN, (Object)this.getPattern().pattern());
        }
        return jSONObject.toString();
    }

    public static enum Type {
        DataDrivenNode,
        StructuralParameter;

    }
}

