/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.StructuralNodeModifier;
import org.zaproxy.zap.view.ContextStructurePanel;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContainer;

public class PopupMenuItemContextDataDrivenNode
extends PopupMenuItemSiteNodeContainer {
    private static final long serialVersionUID = 990419495607725846L;
    protected Context context;

    public PopupMenuItemContextDataDrivenNode(Context context, String string) {
        super(string, true);
        this.context = context;
    }

    @Override
    public String getParentMenuName() {
        return Constant.messages.getString("context.flag.popup");
    }

    @Override
    public boolean isSubMenu() {
        return true;
    }

    @Override
    public void performAction(SiteNode siteNode) {
        Session session = Model.getSingleton().getSession();
        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
        sessionDialog.recreateUISharedContexts(session);
        Context context = sessionDialog.getUISharedContext(this.context.getIndex());
        StringBuilder stringBuilder = new StringBuilder();
        SiteNode siteNode2 = siteNode.getParent();
        while (!siteNode2.getParent().isRoot()) {
            stringBuilder.insert(0, "/");
            if (siteNode2.isDataDriven()) {
                stringBuilder.insert(0, ".+?");
            } else {
                stringBuilder.insert(0, siteNode2.getCleanNodeName());
            }
            siteNode2 = siteNode2.getParent();
        }
        stringBuilder.insert(0, "/(");
        stringBuilder.insert(0, siteNode2.getCleanNodeName());
        stringBuilder.append(")(.+?)(/.*)");
        Pattern pattern = Pattern.compile(stringBuilder.toString());
        context.addDataDrivenNodes(new StructuralNodeModifier(StructuralNodeModifier.Type.DataDrivenNode, pattern, context.getDefaultDDNName()));
        View.getSingleton().showSessionDialog(session, ContextStructurePanel.getPanelName(this.context.getIndex()), false);
    }

    @Override
    public boolean isButtonEnabledForSiteNode(SiteNode siteNode) {
        return siteNode.getLevel() > 2;
    }

    @Override
    public boolean isSafe() {
        return true;
    }
}

