/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.popup;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.zaproxy.zap.extension.ExtensionPopupMenu;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;

public final class PopupMenuUtils {
    private PopupMenuUtils() {
    }

    public static boolean isAtLeastOneChildComponentVisible(Container container) {
        for (Component component : container.getComponents()) {
            if (!component.isVisible()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAtLeastOneChildComponentVisible(JMenu jMenu) {
        return PopupMenuUtils.isAtLeastOneChildComponentVisible(jMenu.getPopupMenu());
    }

    public static boolean isExtensionPopupMenuItem(Component component) {
        return component instanceof ExtensionPopupMenuItem;
    }

    public static boolean isExtensionPopupMenu(Component component) {
        return component instanceof ExtensionPopupMenu;
    }

    public static boolean isExtensionPopupMenuComponent(Component component) {
        return component instanceof ExtensionPopupMenuComponent;
    }

    public static boolean isExtensionPopupMenuComponent(MenuElement menuElement) {
        return menuElement instanceof ExtensionPopupMenuComponent;
    }

    public static boolean isPopupMenuSeparator(Component component) {
        return component instanceof JPopupMenu.Separator;
    }

    public static void removeAllSeparators(JPopupMenu jPopupMenu) {
        for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
            if (!PopupMenuUtils.isPopupMenuSeparator(jPopupMenu.getComponent(i))) continue;
            jPopupMenu.remove(i);
            --i;
        }
    }

    public static void removeAllSeparators(JMenu jMenu) {
        PopupMenuUtils.removeAllSeparators(jMenu.getPopupMenu());
    }

    public static void removeConsecutiveSeparators(JPopupMenu jPopupMenu) {
        for (int i = 1; i < jPopupMenu.getComponentCount(); ++i) {
            if (!PopupMenuUtils.isPopupMenuSeparator(jPopupMenu.getComponent(i)) || !PopupMenuUtils.isPopupMenuSeparator(jPopupMenu.getComponent(i - 1))) continue;
            jPopupMenu.remove(i);
            --i;
        }
    }

    public static void removeConsecutiveSeparators(JMenu jMenu) {
        PopupMenuUtils.removeConsecutiveSeparators(jMenu.getPopupMenu());
    }

    public static void removeTopSeparators(JPopupMenu jPopupMenu) {
        while (jPopupMenu.getComponentCount() > 0 && PopupMenuUtils.isPopupMenuSeparator(jPopupMenu.getComponent(0))) {
            jPopupMenu.remove(0);
        }
    }

    public static void removeTopSeparators(JMenu jMenu) {
        PopupMenuUtils.removeTopSeparators(jMenu.getPopupMenu());
    }

    public static void removeBottomSeparators(JPopupMenu jPopupMenu) {
        for (int i = jPopupMenu.getComponentCount() - 1; i >= 0 && PopupMenuUtils.isPopupMenuSeparator(jPopupMenu.getComponent(i)); --i) {
            jPopupMenu.remove(i);
        }
    }

    public static void removeBottomSeparators(JMenu jMenu) {
        PopupMenuUtils.removeBottomSeparators(jMenu.getPopupMenu());
    }

    public static void removeTopAndBottomSeparators(JPopupMenu jPopupMenu) {
        if (jPopupMenu.getComponentCount() == 0) {
            return;
        }
        PopupMenuUtils.removeTopSeparators(jPopupMenu);
        PopupMenuUtils.removeBottomSeparators(jPopupMenu);
    }

    public static void removeTopAndBottomSeparators(JMenu jMenu) {
        PopupMenuUtils.removeTopAndBottomSeparators(jMenu.getPopupMenu());
    }

    public static boolean addSeparatorIfNeeded(JPopupMenu jPopupMenu) {
        int n = jPopupMenu.getComponentCount();
        if (n == 0) {
            return false;
        }
        Component component = jPopupMenu.getComponent(n - 1);
        if (PopupMenuUtils.isPopupMenuSeparator(component)) {
            return false;
        }
        jPopupMenu.addSeparator();
        return true;
    }

    public static boolean addSeparatorIfNeeded(JMenu jMenu) {
        return PopupMenuUtils.addSeparatorIfNeeded(jMenu.getPopupMenu());
    }

    public static boolean insertSeparatorIfNeeded(JPopupMenu jPopupMenu, int n) {
        int n2 = jPopupMenu.getComponentCount();
        if (n2 == 0 || n <= 0 || n > n2) {
            return false;
        }
        Component component = jPopupMenu.getComponent(n);
        if (PopupMenuUtils.isPopupMenuSeparator(component)) {
            return false;
        }
        Component component2 = jPopupMenu.getComponent(n - 1);
        if (PopupMenuUtils.isPopupMenuSeparator(component2)) {
            return false;
        }
        jPopupMenu.insert(new JPopupMenu.Separator(), n);
        return true;
    }

    public static boolean insertSeparatorIfNeeded(JMenu jMenu, int n) {
        return PopupMenuUtils.insertSeparatorIfNeeded(jMenu.getPopupMenu(), n);
    }

    public static PopupMenuInvokerWrapper getPopupMenuInvokerWrapper(Component component) {
        return new ComponentPopupMenuInvoker(component);
    }

    public static PopupMenuInvokerWrapper getPopupMenuInvokerWrapper(MessageContainer<?> messageContainer) {
        return new MessageContainerPopupMenuInvoker(messageContainer);
    }

    public static class MessageContainerPopupMenuInvoker
    extends PopupMenuInvokerWrapper {
        private final MessageContainer<?> messageContainer;

        public MessageContainerPopupMenuInvoker(MessageContainer<?> messageContainer) {
            super(messageContainer.getComponent());
            this.messageContainer = messageContainer;
        }

        @Override
        public boolean isEnable(ExtensionPopupMenuComponent extensionPopupMenuComponent) {
            return extensionPopupMenuComponent.isEnableForMessageContainer(this.messageContainer);
        }
    }

    public static class ComponentPopupMenuInvoker
    extends PopupMenuInvokerWrapper {
        public ComponentPopupMenuInvoker(Component component) {
            super(component);
        }

        @Override
        public boolean isEnable(ExtensionPopupMenuComponent extensionPopupMenuComponent) {
            return extensionPopupMenuComponent.isEnableForComponent(this.getComponent());
        }
    }

    public static abstract class PopupMenuInvokerWrapper {
        private final Component component;

        public PopupMenuInvokerWrapper(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("Parameter component must not be null.");
            }
            this.component = component;
        }

        public Component getComponent() {
            return this.component;
        }

        public abstract boolean isEnable(ExtensionPopupMenuComponent var1);
    }
}

