#!/bin/ksh
#
# bulk delete of devices from NeDi DB
# for info, refer to command line option -h
#
# Till Elsner <elsner@acm.org>
#

function usage {
	echo "Delete multiple devices from NeDi DB"
	echo "bulkdelete.sh [-u username] [-p password] [-d database] [(-r regexp)|(-e device)]"
	echo "bulkdelete.sh -h"
	echo
	echo -e "-u username\tuser name for database connection"
	echo -e "-p password\tpassword for database connection"
	echo -e "-d database\tdatabase to connect to (optional, defaults to 'nedi')"
	echo -e "-r expression\tmatch devices to be deleted by regular expression"
	echo -e "-e device\tdelete device with exactly matching name"
	echo -e "-h\t\thelp"
}

function getDevices {
	[ "$2" = 'r' ] && OP="REGEXP" || OP="="
	mysql -u $DBUSER --password=$DBPASS -BN -e "SELECT name FROM devices WHERE name $OP '$1'" nedi
}

function deleteDevice {
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM devices WHERE name = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM interfaces WHERE device = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM modules WHERE device = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM links WHERE device = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM links WHERE neighbour = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM configs WHERE device = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM monitoring WHERE device = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM incidents WHERE device = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM vlans WHERE device = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM networks WHERE device = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "DELETE FROM events WHERE source = '$1'" nedi && \
	mysql -u $DBUSER --password=$DBPASS -e "INSERT INTO devdel (device, user, time) VALUES ('$1', 'admin', UNIX_TIMESTAMP())" nedi
}

while [ -n "$1" ]
do
	case "$1" in
		-h)
			usage
			exit
			;;
		-u)
			shift
			if [ -z "`echo "$1" | egrep -o "^[-]"`" ]
			then
				DBUSER=$1
			else
				echo "Expected user name with -u"
				exit 1
			fi
			shift
			;;
		-p)
			shift
			if [ -z "`echo "$1" | egrep -o "^[-]"`" ]
			then
				DBPASS=$1
			else
				echo "Expected password with -p"
				exit 1
			fi
			shift
			;;
		-d)
			shift
			if [ -z "`echo "$1" | egrep -o "^[-]"`" ]
			then
				DBNAME=$1
			else
				echo "Expected database name with -d"
				exit 1
			fi
			shift
			;;
		-r)
			shift
			if [ -z "`echo "$1" | egrep -o "^[-]"`" ]
			then
				MATCHEXP=$1
				MATCHTYPE='r'
			else
				echo "Expected regualar expression -r"
				exit 1
			fi
			shift
			;;
		-e)
			shift
			if [ -z "`echo "$1" | egrep -o "^[-]"`" ]
			then
				MATCHEXP=$1
				MATCHTYPE='e'
			else
				echo "Expected device name with -e"
				exit 1
			fi
			shift
			;;
		*)
			echo "Unknown parameter $1"
			exit 1
			;;
	esac
done

if [ -z "$DBUSER" ]
then
	echo -e "Enter username for database: \c "
	read DBUSER
	echo
fi

if [ -z "$DBPASS" ]
then
	echo -e "Enter password for database user '$DBUSER': \c "
	stty -echo
	read DBPASS
	stty echo
	echo
fi

[ -z "$DBNAME" ] && DBNAME="nedi"

if [ -z "$MATCHTYPE" ]
then
	while [ "$MATCHTYPE" != 'r' -a "$MATCHTYPE" != 'e' ]
	do
		echo -e "Match devices names (e)xactly or by (r)egular expression? \c "
		read 1 MATCHTYPE
	done
fi

if [ -z "$MATCHEXP" ]
then
	if [ $MATCHTYPE = 'e' ]
	then
		echo -e "Delete device: \c "
	else
		echo -e "Delete devices matching the following regular expression: \c "
	fi
	read MATCHEXP
fi

if [ $MATCHTYPE = 'e' ]
then
	DEVICE=$(getDevices "$MATCHEXP" 'e')
	[ $? -gt 0 ] && exit 2
	if [ -z "$DEVICE" ]
	then
		echo "Device '$MATCHEXP' not found"
		exit
	fi
	while [ "$DO" != 'y' -a "$DO" != 'n' ]
	do
		echo -e "Delete device '$DEVICE'? (y/n) \c "
		read DO
	done
	[ "$DO" = 'y' ] && deleteDevice "$DEVICE"
else
	for DEV in $(getDevices "$MATCHEXP" 'r')
	do
		[ $? -gt 0 ] && exit 2
		DEVICES[${#DEVICES[@]}]=$DEV
	done
	if [ ${#DEVICES[@]} -eq 0 ]
	then
		echo "No devices matching '$MATCHEXP' found"
		exit
	fi
	echo "Devices matching '$MATCHEXP':"
	i=0
	while [ $i -lt ${#DEVICES[@]} ]
	do
		echo ${DEVICES[$i]}
		(( i += 1 ))
	done
	while [ "$DO" != 'y' -a "$DO" != 'n' ]
	do
		echo -e "Delete all matching devices? (y/n) \c "
		read DO
	done
	if [ "$DO" = 'y' ]
	then
		i=0
		while [ $i -lt ${#DEVICES[@]} ]
		do
			deleteDevice "${DEVICES[$i]}"
			(( i += 1 ))
		done
	fi
fi
