# Copyright (c) 2004
#   Riverbank Computing Limited <info@riverbankcomputing.co.uk>
#   Jim Bublitz <jbublitz@nwinternet.com>
#
# This file is part of PyKDE.
#
# This copy of PyKDE is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.
#
# PyKDE is supplied in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# PyKDE; see the file LICENSE.  If not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# This module is intended to be used by the configuration scripts of extension
# modules that %Import PyKDE modules.


import sipconfig, PyQt4.pyqtconfig


# These are installation specific values created when PyKDE was configured.
# 
kde_version_parts = '4.14.10'.split('.')
kde_version_hex = int(kde_version_parts[0])*65536 + int(kde_version_parts[1])*256 + int(kde_version_parts[2])
_pkg_config = {
    'dist_name':            '',
    'kde_version':          kde_version_hex,
    'kde_version_extra':    '',
    'kde_version_sfx':      '',
    'kde_version_str':      '4.14.10',
    'kdebasedir':           '/usr/local',
    'kdeincdir':            '/usr/local/include/kde4',
    'kdelibdir':            '/usr/local/lib/kde4/libs',
    'konsolepart':          'False',
    'libdir':               'libs',
    'pykde_kde_sip_flags':  ' -t ALL -t WS_X11 -t Qt_4_8_6  -X VendorID -X PyQt_NoPrintRangeBug -P;-g;-x;PyKDE_QVector;-x;Py_v3;-x;PyKDE_GLuint',
    'pykde_mod_dir':        '/usr/local/lib/python2.7/site-packages/PyKDE4',
    'pykde_modules':        '',
    'pykde_sip_dir':        '/usr/local/share/sip/PyKDE4',
    'pykde_version':        kde_version_hex,
    'pykde_version_str':    '4.14.10'
}

_default_macros = None



class Configuration(PyQt4.pyqtconfig.Configuration):
    """The class that represents PyQt configuration values.
    """
    def __init__(self, sub_cfg=None):
        """Initialise an instance of the class.

        sub_cfg is the list of sub-class configurations.  It should be None
        when called normally.
        """
        if sub_cfg:
            cfg = sub_cfg
        else:
            cfg = []

        cfg.append(_pkg_config)

        PyQt4.pyqtconfig.Configuration.__init__(self, cfg)


class KdecoreModuleMakefile(PyQt4.pyqtconfig.QtCoreModuleMakefile):
    """The Makefile class for modules that %Import kdecore.
    """
    def finalise(self):
        """Finalise the macros.
        """

        PyQt4.pyqtconfig.QtCoreModuleMakefile.finalise(self)

class SolidModuleMakefile(KdecoreModuleMakefile):
    """The Makefile class for modules that %Import kdesu.
    """
    def finalise(self):
        """Finalise the macros.
        """

        KdecoreModuleMakefile.finalise(self)

class KdefxModuleMakefile(SolidModuleMakefile):
    """The Makefile class for modules that %Import kdefx.
    """
    def finalise(self):
        """Finalise the macros.
        """
        
        SolidModuleMakefile.finalise(self)

class KdeuiModuleMakefile(KdefxModuleMakefile):
    """The Makefile class for modules that %Import kdeui.
    """
    def finalise(self):
        """Finalise the macros.
        """

        KdefxModuleMakefile.finalise(self)

class KioModuleMakefile(KdeuiModuleMakefile):
    """The Makefile class for modules that %Import kio.
    """
    def finalise(self):
        """Finalise the macros.
        """

        KdeuiModuleMakefile.finalise(self)


class KpartsModuleMakefile(KioModuleMakefile):
    """The Makefile class for modules that %Import kparts.
    """
    def finalise(self):
        """Finalise the macros.
        """

        KioModuleMakefile.finalise(self)

class KhtmlModuleMakefile(KpartsModuleMakefile):
    """The Makefile class for modules that %Import khtml.
    """
    def finalise(self):
        """Finalise the macros.
        """

        KpartsModuleMakefile.finalise(self)


class KdeprintModuleMakefile(KhtmlModuleMakefile):
    """The Makefile class for modules that %Import kdeprint.
    """
    def finalise(self):
        """Finalise the macros.
        """

        KhtmlModuleMakefile.finalise(self)
