/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.autofit;

import gnu.java.awt.font.autofit.AxisHints;
import gnu.java.awt.font.autofit.Constants;
import gnu.java.awt.font.autofit.Edge;
import gnu.java.awt.font.autofit.ScriptMetrics;
import gnu.java.awt.font.autofit.Segment;
import gnu.java.awt.font.autofit.Utils;
import gnu.java.awt.font.opentype.truetype.Fixed;
import gnu.java.awt.font.opentype.truetype.Point;
import gnu.java.awt.font.opentype.truetype.Zone;

class GlyphHints
implements Constants {
    int xScale;
    int xDelta;
    int yScale;
    int yDelta;
    AxisHints[] axis = new AxisHints[2];
    Point[] points;
    int numPoints;
    int maxPoints;
    Point[] contours;
    int numContours;
    int maxContours;
    ScriptMetrics metrics;
    int flags;

    GlyphHints() {
        this.axis[1] = new AxisHints();
        this.axis[0] = new AxisHints();
        this.xScale = 64;
        this.yScale = 64;
    }

    void rescale(ScriptMetrics m) {
        this.metrics = m;
    }

    void reload(Zone outline) {
        this.numPoints = 0;
        this.numContours = 0;
        this.axis[0].numSegments = 0;
        this.axis[0].numEdges = 0;
        this.axis[1].numSegments = 0;
        this.axis[1].numEdges = 0;
        int newMax = outline.getNumContours();
        if (newMax > this.maxContours || this.contours == null) {
            newMax = newMax + 3 & 0xFFFFFFFC;
            Point[] newContours = new Point[newMax];
            if (this.contours != null) {
                System.arraycopy(this.contours, 0, newContours, 0, this.maxContours);
            }
            this.contours = newContours;
            this.maxContours = newMax;
        }
        if ((newMax = outline.getSize() + 2) > this.maxPoints || this.points == null) {
            newMax = newMax + 2 + 7 & 0xFFFFFFF8;
            Point[] newPoints = new Point[newMax];
            if (this.points != null) {
                System.arraycopy(this.points, 0, newPoints, 0, this.maxPoints);
            }
            this.points = newPoints;
            this.maxPoints = newMax;
        }
        this.numPoints = outline.getSize() - 4;
        this.numContours = outline.getNumContours();
        this.axis[0].majorDir = 2;
        this.axis[1].majorDir = -1;
        this.xScale = Fixed.valueOf16(outline.scaleX * 64.0);
        this.yScale = Fixed.valueOf16(outline.scaleY * 64.0);
        System.arraycopy(outline.getPoints(), 0, this.points, 0, this.numPoints);
        this.contours = new Point[this.numContours];
        Point currentContour = this.points[0];
        int i = 0;
        int cIndex = 0;
        while (i < this.numPoints) {
            if (outline.isContourEnd(i)) {
                this.points[i].setNext(currentContour);
                currentContour.setPrev(this.points[i]);
                this.contours[cIndex] = currentContour;
                ++cIndex;
                currentContour = i < this.numPoints - 1 ? this.points[i + 1] : null;
            } else {
                this.points[i].setNext(this.points[i + 1]);
                this.points[i + 1].setPrev(this.points[i]);
            }
            ++i;
        }
        i = 0;
        while (i < this.numPoints) {
            Point p = this.points[i];
            Point prev = p.getPrev();
            int inX = p.getOrigX() - prev.getOrigX();
            int inY = p.getOrigY() - prev.getOrigY();
            p.setInDir(Utils.computeDirection(inX, inY));
            Point next = p.getNext();
            int outX = next.getOrigX() - p.getOrigX();
            int outY = next.getOrigY() - p.getOrigY();
            p.setOutDir(Utils.computeDirection(outX, outY));
            if (p.isControlPoint()) {
                this.setWeakPoint(p);
            } else if (p.getOutDir() == p.getInDir()) {
                if (p.getOutDir() != 0) {
                    this.setWeakPoint(p);
                } else {
                    int angleOut;
                    int angleIn = Utils.atan(inY, inX);
                    int delta = Utils.angleDiff(angleIn, angleOut = Utils.atan(outY, outX));
                    if (delta < 2 && delta > -2) {
                        this.setWeakPoint(p);
                    }
                }
            } else if (p.getInDir() == -p.getOutDir()) {
                this.setWeakPoint(p);
            }
            ++i;
        }
        this.computeInflectionPoints();
    }

    private void setWeakPoint(Point p) {
        p.setFlags((byte)(p.getFlags() | 0x10));
    }

    private void computeInflectionPoints() {
        int c = 0;
        while (c < this.contours.length) {
            Point point;
            Point first = point = this.contours[c];
            Point start = point;
            Point end = point;
            block1: while ((end = end.getNext()) != first) {
                int angleIn;
                if (end.getOrigX() == first.getOrigX() && end.getOrigY() == first.getOrigY()) continue;
                Point before = start;
                int angleSeg = Utils.atan(end.getOrigX() - start.getOrigX(), end.getOrigY() - start.getOrigY());
                do {
                    start = before;
                    if ((before = before.getPrev()) == first) break block1;
                } while (before.getOrigX() == start.getOrigX() && before.getOrigY() == start.getOrigY() || (angleIn = Utils.atan(start.getOrigX() - before.getOrigX(), start.getOrigY() - before.getOrigY())) == angleSeg);
                first = start;
                int diffIn = Utils.angleDiff(angleIn, angleSeg);
                boolean finished = false;
                do {
                    int angleOut;
                    Point after = end;
                    do {
                        end = after;
                        if ((after = after.getNext()) != first) continue;
                        finished = true;
                    } while (end.getOrigX() == after.getOrigX() && end.getOrigY() == after.getOrigY() || (angleOut = Utils.atan(after.getOrigX() - end.getOrigX(), after.getOrigY() - end.getOrigY())) == angleSeg);
                    int diffOut = Utils.angleDiff(angleSeg, angleOut);
                    if ((diffIn ^ diffOut) < 0) {
                        do {
                            start.addFlags((short)32);
                        } while ((start = start.getNext()) != end);
                        start.addFlags((short)32);
                    }
                    start = end;
                    end = after;
                    angleSeg = angleOut;
                    diffIn = diffOut;
                } while (!finished);
            }
            ++c;
        }
    }

    boolean doHorizontal() {
        return (this.flags & 2) == 0;
    }

    boolean doVertical() {
        return (this.flags & 4) == 0;
    }

    void alignWeakPoints(int dim) {
        Point point;
        int p;
        int touchFlag;
        if (dim == 0) {
            touchFlag = 64;
            p = 0;
            while (p < this.numPoints) {
                point = this.points[p];
                point.setU(point.getX());
                point.setV(point.getScaledX());
                ++p;
            }
        } else {
            touchFlag = 128;
            p = 0;
            while (p < this.numPoints) {
                point = this.points[p];
                point.setU(point.getY());
                point.setV(point.getScaledY());
                ++p;
            }
        }
        point = this.points[0];
        int c = 0;
        while (c < this.numContours) {
            point = this.contours[c];
            int idx = this.getPointIndex(point);
            Point endPoint = point.getPrev();
            int endIdx = this.getPointIndex(endPoint);
            int firstIdx = idx;
            while (idx <= endIdx && (point.getFlags() & touchFlag) == 0) {
                point = this.points[++idx];
            }
            if (idx <= endIdx) {
                int firstTouched = idx;
                int curTouched = idx++;
                point = this.points[idx];
                while (idx <= endIdx) {
                    if ((point.getFlags() & touchFlag) != 0) {
                        this.iupInterp(curTouched + 1, idx - 1, curTouched, idx);
                        curTouched = idx;
                    }
                    point = this.points[++idx];
                }
                if (curTouched == firstTouched) {
                    this.iupShift(firstIdx, endIdx, curTouched);
                } else {
                    this.iupInterp(curTouched + 1, endIdx, curTouched, firstTouched);
                    if (firstTouched > 0) {
                        this.iupInterp(firstIdx, firstTouched - 1, curTouched, firstTouched);
                    }
                }
            }
            ++c;
        }
        if (dim == 0) {
            p = 0;
            while (p < this.numPoints) {
                point = this.points[p];
                point.setX(point.getU());
                ++p;
            }
        } else {
            p = 0;
            while (p < this.numPoints) {
                point = this.points[p];
                point.setY(point.getU());
                ++p;
            }
        }
    }

    private void iupShift(int p1, int p2, int ref) {
        int delta = this.points[ref].getU() - this.points[ref].getV();
        int p = p1;
        while (p < ref) {
            this.points[p].setU(this.points[p].getV() + delta);
            ++p;
        }
        p = ref + 1;
        while (p <= p2) {
            this.points[p].setU(this.points[p].getV() + delta);
            ++p;
        }
    }

    private void iupInterp(int p1, int p2, int ref1, int ref2) {
        int v1 = this.points[ref1].getV();
        int v2 = this.points[ref2].getV();
        int d1 = this.points[ref1].getU() - v1;
        int d2 = this.points[ref2].getU() - v2;
        if (p1 > p2) {
            return;
        }
        if (v1 == v2) {
            int p = p1;
            while (p <= p2) {
                int u = this.points[p].getV();
                u = u <= v1 ? (u += d1) : (u += d2);
                this.points[p].setU(u);
                ++p;
            }
        } else if (v1 < v2) {
            int p = p1;
            while (p <= p2) {
                int u = this.points[p].getV();
                u = u <= v1 ? (u += d1) : (u >= v2 ? (u += d2) : this.points[ref1].getU() + Utils.mulDiv(u - v1, this.points[ref2].getU() - this.points[ref1].getU(), v2 - v1));
                this.points[p].setU(u);
                ++p;
            }
        } else {
            int p = p1;
            while (p <= p2) {
                int u = this.points[p].getV();
                u = u <= v2 ? (u += d2) : (u >= v1 ? (u += d1) : this.points[ref1].getU() + Utils.mulDiv(u - v1, this.points[ref2].getU() - this.points[ref1].getU(), v2 - v1));
                this.points[p].setU(u);
                ++p;
            }
        }
    }

    void alignStrongPoints(int dim) {
        AxisHints ax = this.axis[dim];
        Edge[] edges = ax.edges;
        int numEdges = ax.numEdges;
        short touchFlag = dim == 0 ? (short)64 : 128;
        if (numEdges > 0) {
            int p = 0;
            while (p < this.numPoints) {
                Point point = this.points[p];
                if ((point.getFlags() & touchFlag) == 0 && ((point.getFlags() & 0x10) == 0 || (point.getFlags() & 0x20) != 0)) {
                    int ou;
                    int u;
                    if (dim == 1) {
                        u = point.getOrigY();
                        ou = point.getScaledY();
                    } else {
                        u = point.getOrigX();
                        ou = point.getScaledX();
                    }
                    int fu = u;
                    Edge edge = edges[0];
                    int delta = edge.fpos - u;
                    if (delta >= 0) {
                        u = edge.pos - (edge.opos - ou);
                        this.storePoint(point, u, dim, touchFlag);
                    } else {
                        edge = edges[numEdges - 1];
                        delta = u - edge.fpos;
                        if (delta >= 0) {
                            u = edge.pos + (ou - edge.opos);
                            this.storePoint(point, u, dim, touchFlag);
                        } else {
                            int min = 0;
                            int max = numEdges;
                            boolean found = false;
                            while (min < max) {
                                int mid = (max + min) / 2;
                                edge = edges[mid];
                                int fpos = edge.fpos;
                                if (u < fpos) {
                                    max = mid;
                                    continue;
                                }
                                if (u > fpos) {
                                    min = mid + 1;
                                    continue;
                                }
                                u = edge.pos;
                                this.storePoint(point, u, dim, touchFlag);
                                found = true;
                                break;
                            }
                            if (!found) {
                                Edge before = edges[min - 1];
                                Edge after = edges[min];
                                if (before.scale == 0) {
                                    before.scale = Fixed.div16(after.pos - before.pos, after.fpos - before.fpos);
                                }
                                u = before.pos + Fixed.mul16(fu - before.fpos, before.scale);
                            }
                            this.storePoint(point, u, dim, touchFlag);
                        }
                    }
                }
                ++p;
            }
        }
    }

    private void storePoint(Point p, int u, int dim, short touchFlag) {
        if (dim == 0) {
            p.setX(u);
        } else {
            p.setY(u);
        }
        p.addFlags(touchFlag);
    }

    void alignEdgePoints(int dim) {
        AxisHints ax = this.axis[dim];
        Edge[] edges = ax.edges;
        int numEdges = ax.numEdges;
        int e = 0;
        while (e < numEdges) {
            Edge edge = edges[e];
            Segment seg = edge.first;
            block1: do {
                Point point = seg.first;
                while (true) {
                    if (dim == 0) {
                        point.setX(edge.pos);
                        point.addFlags((short)64);
                    } else {
                        point.setY(edge.pos);
                        point.addFlags((short)128);
                    }
                    if (point == seg.last) continue block1;
                    point = point.getNext();
                }
            } while ((seg = seg.edgeNext) != edge.first);
            ++e;
        }
    }

    private int getPointIndex(Point p) {
        int idx = -1;
        int i = 0;
        while (i < this.numPoints) {
            if (p == this.points[i]) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    public boolean doAlignEdgePoints() {
        return (this.flags & 8) == 0;
    }

    public boolean doAlignStrongPoints() {
        return (this.flags & 0x10) == 0;
    }

    public boolean doAlignWeakPoints() {
        return (this.flags & 0x20) == 0;
    }
}

