/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.Hinter;
import gnu.java.awt.font.opentype.truetype.GlyphLocator;
import gnu.java.awt.font.opentype.truetype.GlyphMeasurer;
import gnu.java.awt.font.opentype.truetype.VirtualMachine;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.geom.AffineTransform;
import java.nio.ByteBuffer;

final class GlyphLoader {
    private final GlyphLocator glyphLocator;
    private final GlyphMeasurer glyphMeasurer;
    private final VirtualMachine vm;
    private final int unitsPerEm;
    private final int[] contourEndPoints;
    private final byte[] pointFlags;
    private static final short ARGS_ARE_WORDS = 1;
    private static final short ARGS_ARE_XY_VALUES = 2;
    private static final short ROUND_XY_TO_GRID = 4;
    private static final short WE_HAVE_A_SCALE = 8;
    private static final short MORE_COMPONENTS = 32;
    private static final short WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final short WE_HAVE_A_TWO_BY_TWO = 128;
    private static final short WE_HAVE_INSTRUCTIONS = 256;
    private static final short USE_MY_METRICS = 512;
    private static final short OVERLAP_COMPOUND = 1024;
    private static final short SCALED_COMPONENT_OFFSET = 2048;
    private static final short UNSCALED_COMPONENT_OFFSET = 4096;

    GlyphLoader(GlyphLocator glyphLocator, VirtualMachine vm, int unitsPerEm, int maxContours, int maxPoints, GlyphMeasurer glyphMeasurer) {
        this.glyphLocator = glyphLocator;
        this.glyphMeasurer = glyphMeasurer;
        this.unitsPerEm = unitsPerEm;
        this.vm = vm;
        this.contourEndPoints = new int[maxContours];
        this.pointFlags = new byte[maxPoints];
    }

    public void loadGlyph(int glyphIndex, double pointSize, AffineTransform transform, boolean antialias, Zone glyphZone, Hinter hinter) {
        glyphZone.setNumPoints(4);
        this.loadSubGlyph(glyphIndex, pointSize, transform, antialias, glyphZone, 0, 0, hinter);
    }

    public void loadGlyph(int glyphIndex, AffineTransform transform, Zone glyphZone, Hinter hinter) {
        this.loadGlyph(glyphIndex, this.unitsPerEm, transform, false, glyphZone, hinter);
    }

    private void loadSubGlyph(int glyphIndex, double pointSize, AffineTransform transform, boolean antialias, Zone glyphZone, int preTranslateX, int preTranslateY, Hinter hinter) {
        ByteBuffer glyph = this.glyphLocator.getGlyphData(glyphIndex);
        if (glyph == null) {
            glyphZone.setNumPoints(4);
            this.setPhantomPoints(glyphIndex, 0, glyphZone);
            glyphZone.transform(pointSize, transform, this.unitsPerEm, preTranslateX, preTranslateY);
            return;
        }
        short numContours = glyph.getShort();
        glyph.getChar();
        glyph.getChar();
        glyph.getChar();
        glyph.getChar();
        if (numContours >= 0) {
            this.loadSimpleGlyph(glyphIndex, pointSize, transform, antialias, numContours, glyph, glyphZone, preTranslateX, preTranslateY, hinter);
        } else {
            this.loadCompoundGlyph(glyphIndex, pointSize, transform, antialias, glyph, glyphZone, preTranslateX, preTranslateY, hinter);
        }
    }

    private void loadSimpleGlyph(int glyphIndex, double pointSize, AffineTransform transform, boolean antialias, int numContours, ByteBuffer glyph, Zone glyphZone, int preTranslateX, int preTranslateY, Hinter hinter) {
        boolean execInstructions = this.vm.setup(pointSize, transform, antialias);
        int i = 0;
        while (i < numContours) {
            this.contourEndPoints[i] = glyph.getChar();
            ++i;
        }
        int numPoints = numContours > 0 ? 1 + this.contourEndPoints[numContours - 1] : 0;
        glyphZone.setNumPoints(numPoints + 4);
        char numInstructions = glyph.getChar();
        int posInstructions = glyph.position();
        glyph.position(posInstructions + numInstructions);
        this.loadFlags(numPoints, glyph);
        this.loadCoordinates(numPoints, glyph, glyphZone);
        i = 0;
        while (i < numContours) {
            glyphZone.setContourEnd(this.contourEndPoints[i], true);
            ++i;
        }
        this.setPhantomPoints(glyphIndex, numPoints, glyphZone);
        glyphZone.transform(pointSize, transform, this.unitsPerEm, preTranslateX, preTranslateY);
        if (execInstructions && hinter != null) {
            hinter.applyHints(glyphZone);
        }
    }

    private void loadCompoundGlyph(int glyphIndex, double pointSize, AffineTransform transform, boolean antialias, ByteBuffer glyph, Zone glyphZone, int preTranslateX, int preTranslateY, Hinter hinter) {
        short flags;
        Zone subGlyphZone = new Zone(glyphZone.getCapacity());
        AffineTransform componentTransform = new AffineTransform();
        int metricsGlyphIndex = glyphIndex;
        do {
            double f;
            double e;
            double b;
            double c;
            double a;
            double d;
            short arg2;
            short arg1;
            flags = glyph.getShort();
            char subGlyphIndex = glyph.getChar();
            if ((flags & 0x200) != 0) {
                metricsGlyphIndex = subGlyphIndex;
            }
            if ((flags & 1) != 0) {
                arg1 = glyph.getShort();
                arg2 = glyph.getShort();
            } else {
                arg1 = glyph.get();
                arg2 = glyph.get();
            }
            if ((flags & 8) != 0) {
                a = d = this.getDouble214(glyph);
                c = 0.0;
                b = 0.0;
            } else if ((flags & 0x40) != 0) {
                a = this.getDouble214(glyph);
                d = this.getDouble214(glyph);
                c = 0.0;
                b = 0.0;
            } else if ((flags & 0x80) != 0) {
                a = this.getDouble214(glyph);
                b = this.getDouble214(glyph);
                c = this.getDouble214(glyph);
                d = this.getDouble214(glyph);
            } else {
                d = 1.0;
                a = 1.0;
                c = 0.0;
                b = 0.0;
            }
            double m = Math.max(Math.abs(a), Math.abs(b));
            double n = Math.max(Math.abs(c), Math.abs(d));
            if (Math.abs(Math.abs(a) - Math.abs(b)) <= 5.035400390625E-4) {
                m *= 2.0;
            }
            if (Math.abs(Math.abs(c) - Math.abs(d)) <= 5.035400390625E-4) {
                n *= 2.0;
            }
            if ((flags & 2) != 0) {
                e = m * (double)arg1;
                f = n * (double)arg2;
            } else {
                f = 0.0;
                e = 0.0;
            }
            componentTransform.setTransform(a, b, c, d, 0.0, 0.0);
            componentTransform.concatenate(transform);
            int pos = glyph.position();
            int lim = glyph.limit();
            this.loadSubGlyph(subGlyphIndex, pointSize, componentTransform, antialias, subGlyphZone, Math.round((float)e + (float)preTranslateX), Math.round(-((float)f + (float)preTranslateY)), hinter);
            glyphZone.combineWithSubGlyph(subGlyphZone, 4);
            glyph.limit(lim).position(pos);
        } while ((flags & 0x20) != 0);
        this.setPhantomPoints(metricsGlyphIndex, glyphZone.getSize() - 4, glyphZone);
    }

    private double getDouble214(ByteBuffer buf) {
        return (double)buf.getShort() / 16384.0;
    }

    private void loadFlags(int numPoints, ByteBuffer glyph) {
        int i = 0;
        while (i < numPoints) {
            byte flag;
            this.pointFlags[i] = flag = glyph.get();
            if ((flag & 8) != 0) {
                int numRepetitions = glyph.get() & 0xFF;
                while (numRepetitions > 0) {
                    this.pointFlags[++i] = flag;
                    --numRepetitions;
                }
            }
            ++i;
        }
    }

    private void loadCoordinates(int numPoints, ByteBuffer glyph, Zone glyphZone) {
        byte flag;
        int x = 0;
        int i = 0;
        while (i < numPoints) {
            flag = this.pointFlags[i];
            if ((flag & 2) == 0) {
                if ((flag & 0x10) == 0) {
                    x += glyph.getShort();
                }
            } else {
                x = (flag & 0x10) != 0 ? (x += glyph.get() & 0xFF) : (x -= glyph.get() & 0xFF);
            }
            glyphZone.setOriginalX(i, x);
            glyphZone.setOnCurve(i, (flag & 1) == 1);
            ++i;
        }
        int y = 0;
        i = 0;
        while (i < numPoints) {
            flag = this.pointFlags[i];
            if ((flag & 4) == 0) {
                if ((flag & 0x20) == 0) {
                    y += glyph.getShort();
                }
            } else {
                y = (flag & 0x20) != 0 ? (y += glyph.get() & 0xFF) : (y -= glyph.get() & 0xFF);
            }
            glyphZone.setOriginalY(i, -y);
            ++i;
        }
    }

    private void setPhantomPoints(int glyphIndex, int numPoints, Zone glyphZone) {
        glyphZone.setOriginalX(numPoints, 0);
        glyphZone.setOriginalY(numPoints, 0);
        glyphZone.setOriginalX(numPoints + 1, this.glyphMeasurer.getAdvanceWidth(glyphIndex, true));
        glyphZone.setOriginalY(numPoints + 1, this.glyphMeasurer.getAdvanceHeight(glyphIndex, true));
        int vertX = this.glyphMeasurer.getAscent(false);
        int vertY = this.glyphMeasurer.getAscent(true);
        glyphZone.setOriginalX(numPoints + 2, vertX);
        glyphZone.setOriginalY(numPoints + 2, vertY);
        glyphZone.setOriginalX(numPoints + 3, vertX + this.glyphMeasurer.getAdvanceWidth(glyphIndex, false));
        glyphZone.setOriginalY(numPoints + 3, vertY + this.glyphMeasurer.getAdvanceHeight(glyphIndex, false));
    }
}

