/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.io.Serializable;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

public class Checkbox
extends Component
implements ItemSelectable,
Accessible,
Serializable {
    private static final long serialVersionUID = 7270714317450821763L;
    private CheckboxGroup group;
    private String label;
    boolean state;
    private transient ItemListener item_listeners;
    private static transient long next_checkbox_number;

    public Checkbox() {
        this("", false, null);
    }

    public Checkbox(String label) {
        this(label, false, null);
    }

    public Checkbox(String label, boolean state) {
        this(label, state, null);
    }

    public Checkbox(String label, CheckboxGroup group, boolean state) {
        this(label, state, group);
    }

    public Checkbox(String label, boolean state, CheckboxGroup group) {
        this.label = label;
        this.state = state;
        this.group = group;
        if (state && group != null) {
            group.setSelectedCheckbox(this);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String label) {
        this.label = label;
        if (this.peer != null) {
            CheckboxPeer cp = (CheckboxPeer)this.peer;
            cp.setLabel(label);
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean state) {
        if (this.state != state) {
            this.state = state;
            if (this.peer != null) {
                CheckboxPeer cp = (CheckboxPeer)this.peer;
                cp.setState(state);
            }
        }
    }

    public Object[] getSelectedObjects() {
        if (!this.state) {
            return null;
        }
        Object[] objs = new Object[]{this.label};
        return objs;
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    public synchronized void setCheckboxGroup(CheckboxGroup group) {
        this.group = group;
        if (this.peer != null) {
            CheckboxPeer cp = (CheckboxPeer)this.peer;
            cp.setCheckboxGroup(group);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckbox(this);
        }
        super.addNotify();
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])AWTEventMulticaster.getListeners((EventListener)this.item_listeners, ItemListener.class);
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 701 && e.id >= 701) {
            ItemEvent ie = (ItemEvent)e;
            int itemState = ie.getStateChange();
            this.setState(itemState == 1);
            if (this.item_listeners != null || (this.eventMask & 0x200L) != 0L) {
                this.processEvent(e);
            }
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected String paramString() {
        return "label=" + this.label + ",state=" + this.state + "," + super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleAWTCheckbox ac = new AccessibleAWTCheckbox();
            this.accessibleContext = ac;
            this.addItemListener(ac);
        }
        return this.accessibleContext;
    }

    String generateName() {
        return "checkbox" + Checkbox.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_checkbox_number++;
    }

    protected class AccessibleAWTCheckbox
    extends Component.AccessibleAWTComponent
    implements ItemListener,
    AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = 7881579233144754107L;

        public void itemStateChanged(ItemEvent event) {
            this.firePropertyChange("AccessibleState", Checkbox.this.state ? null : AccessibleState.CHECKED, Checkbox.this.state ? AccessibleState.CHECKED : null);
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int i) {
            return null;
        }

        public boolean doAccessibleAction(int i) {
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet set = super.getAccessibleStateSet();
            if (Checkbox.this.state) {
                set.add(AccessibleState.CHECKED);
            }
            return set;
        }
    }
}

