# Dictionary is a list of key-value pairs, which is quite similar to hash, but
# performs tests for errors.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Dictionary;

use strict;

sub new ($$) {
    my ($class_name, $init_gloss) = @_;

    my $self = { _storage => {} };
    bless $self, $class_name;

    $self->add_gloss($init_gloss)
    or do {
        warn "Can not initialize dictionary.";
    return undef;
    };

    return $self;
}

sub add_pair ($$$) {
    my ($self, $key, $value) = @_;

# TBD: test key and format

    if (defined $self->{_storage}->{$key}) {
        warn "The key '$key' is already defined.";
        return 0;
    }

    $self->{_storage}->{$key} = $value;
    return 1;
}

sub add_gloss ($$) {
    my ($self, $gloss) = @_;

    foreach (keys %$gloss) {
        return 0 unless ($self->add_pair($_, $gloss->{$_}));
    }

    return 1;
}

sub get_value ($$) {
    my ($self, $key) = @_;

    unless (defined $self->{_storage}->{$key}) {
        warn "The key '$key' is not yet defined.";
        return undef;
    }

    return $self->{_storage}->{$key};
}

sub change_value ($$$) {
    my ($self, $key, $value) = @_;

    unless (defined $self->{_storage}->{$key}) {
        warn "The key '$key' is not yet defined.";
        return undef;
    }

    return $self->{_storage}->{$key} = $value;
}

1
