# The Config class defines settings specific to the DocumentMode.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::DocumentMode::Config;

our @ISA = qw(CMSsh::Config);

use strict;
use utf8;

################################################################################
# Configuration parameters

my $Settings = {
    DIR_ICON =>             '.icons',
    DIR_DOC =>              'text',
    EXT_DOC =>              'mkd',
    ROOT_DESC_NAME =>       'main',
    PREVIEWS_PER_PAGE =>    10,
    DATE_TMPL =>            '%e %b %Y',
};

################################################################################
# Do not edit below this line

sub new ($) {
    my ($class_name) = @_;

    my $self = CMSsh::Config->new;
    $self->_install_gloss($Settings);

    $self->_install_param('MMKD_PARAMS', { empty_element_suffix => '>',
                                           strip_metadata => 1,
                                           img_ids => 0 });
    $self->_install_param('HTDOCS_DOC', $self->get('HTDOCS_MEDIA') . '/' .
                                        $self->get('DIR_DOC'));
    $self->_install_param('HTDOCS_ICON', $self->get('HTDOCS_IMG') . '/' .
                                         $self->get('DIR_ICON'));
    $self->_install_param('ROOT_DOC', $self->get('ROOT_HTDOCS') .
                                      $self->get('HTDOCS_DOC'));
    $self->_install_param('ROOT_ICON', $self->get('ROOT_HTDOCS') .
                                       $self->get('HTDOCS_ICON'));

    bless $self, $class_name;
    return $self;
}

1
