# View is the interface between a Mode and the Presentation layer. It provides
# information which is used to build common UI elements like menu items and
# publication path.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Mode::View;

use strict;

sub new ($$) {
    my ($class_name, $mode) = @_;

    my $self = { _mode => $mode };

    bless $self, $class_name;
    return $self;
}

sub get_tmpl_params (;$) {
    return [];
}

sub get_menu_items ($$) {
    return [];
}

sub get_path ($$) {
    return [];
}

sub get_mode ($) {
    my $self = shift;
    return $self->{_mode};
}

1
