# This module contains subroutines specific for the Presentation layer.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Presentation::Utils;

use strict;
use CGI;
use Template;
use CMSsh::Config;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw(cgi_die);

my $Cgi = CGI->new;
my $Cfg = CMSsh::Config->new;

sub cgi_die ($) {
    my $message = shift;

# Send headers
    print $Cgi->header(-charset => 'utf-8',
                       -cache_control => 'no-cache, no-store, must-revalidate');

# Prepare template variables
    my $vars = {
        message => $message,
        title => 'Error',
        mode => 'error',
    };
    my @err_tmpl_params = qw(COPYRIGHT_YEARS LICENSE OWNER_NAME OWNER_EMAIL);
    $vars->{lc($_)} = $Cfg->get($_) foreach (@err_tmpl_params);

# Handle the template
    my $tt = Template->new({ INCLUDE_PATH => $Cfg->get('ROOT_TMPL') }) ||
        die $Template::ERROR, "\n";
    $tt->process('error.tmpl', $vars);

    exit 1;
}

1
