# VidFile is a type of file. On the file system layer it contains a video.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::VideoMode::VidFile;

our @ISA = qw(CMSsh::FileSystem::TypedFile);

use strict;
use CMSsh::FileSystem::TypedFile;
use CMSsh::VideoMode::Config;
use CMSsh::VideoMode::Messages;

my $Cfg = CMSsh::VideoMode::Config->new;
my $Msg = CMSsh::VideoMode::Messages->new;

sub new ($$) {
    my ($class_name, $abs_path) = @_;

    my $self = CMSsh::FileSystem::TypedFile->new($abs_path, get_ext());
    unless ($self) {
        warn $Msg->get('CANT_INST_FSO', $abs_path);
        return undef;
    }
    
    bless $self, $class_name;
    return $self;
}

sub get_ext (;$) {
    return $Cfg->get('EXT_VIDEO');
}

1
