/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef APPSETTINGS_H
#define APPSETTINGS_H

#include "misch.h"
#include "smsmessage.h"
#include <qdir.h>
#include <qpixmap.h>
#include <qfile.h>
#include <qmessagebox.h>
#include <qsettings.h>

/**
@author GUILLAUME Nicolas
*/
class AppSettings
{
private:
	bool start_min, auto_start_deamon, show_popup, show_deamon_error, prefix_num;
	QString rm_phonebook, popup_sound, contact_pattern, popup_pixmap_path;
	QPixmap popup_pixmap;
	SMSManager::SMSContact contact_local;
	SMSManager::SMSDeviceConfig dev_config;
	
	QString cfg_path;
	void createBoxFile(const QString& name) const;
	void createPhoneBookFile() const;
public:
	AppSettings();
	~AppSettings();
	
	void loadSettings();
	void saveSettings() const;
	
	QString phoneBookFilePath() const;
	QString boxFilePath(const QString& name) const;
	QString configPath() const;
	QString remotePhoneBook() const;
	SMSManager::SMSDeviceConfig deviceConfig() const;
	SMSManager::SMSContact localContact() const;
	
	bool startMin() const;
	bool autoStartDeamon() const;
	const QString& contactPattern() const;
	
	bool showPopup() const;
	const QPixmap& popupPixmap() const;
	QString popupSound() const;
	
	bool prefixIncomingNumber() const;
	bool showDeamonError() const;
	
	friend class FormCfg;
};

#endif
