/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/
#include "contactlist.h"

namespace SMSManager {

	ContactList::ContactList(QObject *parent, const char *name)
	: QObject(parent, name)
	{
	}
	
	ContactList::ContactList(const ContactList&)
	: QObject(0)
	{
	}
	
	
	ContactList::~ContactList()
	{
		clear();
	}
	
	void ContactList::loadFromFile(const QString& filename)
	{
		clear();
		opened_file = filename;
		QFile file( filename );
		if ( file.open( IO_ReadOnly ) )
		{
			QTextStream stream( &file );
			while ( !stream.atEnd() )
			{
				QString line (stream.readLine().stripWhiteSpace() );
				if( line.length() > 3 )
					contact_list.push_back( SMSContact::fromString( line ) );
			}
	
		}
		file.close();
	}

	void ContactList::saveToFile(const QString& path) 
	{
		DB_MSG(QString(path.isEmpty() ? opened_file : path));
		QFile file( QString(path.isEmpty() ? opened_file : path)  );
		if ( file.open( IO_WriteOnly ) )
		{
			DB_MSG("file opened");
			QTextStream stream( &file );
			for(SMSContactList::iterator it = contact_list.begin(); it != contact_list.end(); it++)
			{
				stream  << (*it).index << PB_SEP
					<< (*it).Name << PB_SEP
					<< (*it).Address << "\n";
			}
		}
		file.close();	
		DB_MSG("file closed");
	}
	
	SMSContact ContactList::getContactName(const SMSContact& rm_contact, bool carePrefix) const
	{
		if(rm_contact.Address.isEmpty())
			return rm_contact;
		else
		{
			SMSContact out(rm_contact);
			for(unsigned int i = 0; i < contact_list.size(); i++)
			{
				SMSContact contact(contact_list.at(i));
				
				if( (contact.Address == out.Address) ||
					(!carePrefix && contact.Address.right(8) == out.Address.right(8)) )
				{
					out.Name = contact.Name;
					return out;
				}
			}
		}	
		return rm_contact;
	}
	
	bool ContactList::importFromPhone(const SMSDeviceConfig& cfg, const QString& pb)
	{
		//gsmpb -c -d - -p "SM" -s /dev/mobile
		QProcessSync import_pb(0);
		
		import_pb.addArgument( "gsmpb" );
		
		cfg.appendArguments(&import_pb, false, false, true);
		
		import_pb.addArgument( "--copy" );
		
		import_pb.addArgument( "-d" );
		import_pb.addArgument( "-" );
		
		import_pb.addArgument( "-p" );
		import_pb.addArgument( pb );
		
		bool ret = import_pb.startSync();
		
		if(!import_pb.getStdErr().isEmpty())
		{
			QMessageBox::warning(0, tr("Erreur"),
					tr("Erreur lors de l'importation des contacts :\n") + import_pb.getStdErr());
			ret = false;
		}
		
		if(ret)
		{
			QStringList lstStr = QStringList::split( '\n', import_pb.getStdOut(), false );
			for(QStringList::Iterator it = lstStr.begin(); it != lstStr.end(); it++)
				contact_list.push_back( SMSContact::fromString( (*it) ) );
		}
		
		return ret;
	}

	void ContactList::exportToPhone(const SMSDeviceConfig&, const QString&)
	{
	}

	void ContactList::syncWithPhone(const SMSDeviceConfig&, const QString&)
	{
	}
	
	int ContactList::contactsCount() const
	{
		return contact_list.size();
	}

	SMSContact ContactList::contact(int index) const
	{
		return contact_list.at(index);
	}
	
	void ContactList::addContact(const SMSContact& contact)
	{
		contact_list.push_back( contact );
	}

	void ContactList::addContacts(const ContactList&)
	{
		DB_NI("addContacts(const ContactList&)");
	}

	void ContactList::removeContact(int index)
	{
		contact_list.erase( SMSContactList::iterator(contact_list.begin() + index) );
	}

	void ContactList::removeAll()
	{
		contact_list.clear();
	}

	void ContactList::clear()
	{
		opened_file = QSTRING_EMPTY;
		contact_list.clear();
	}
	
	void ContactList::sortContacts()
	{
		sort(contact_list.begin(), contact_list.end(), SortContact());
	}
	
	void ContactList::replaceIndex()
	{
		int i = 0;
		for(SMSContactList::iterator it = contact_list.begin(); it != contact_list.end(); it++)
			(*it).index = i++;
	}

	SMSContactList ContactList::getContactsFromName(const QString& str)
	{
		SMSContactList list;
		
		for(SMSContactList::iterator it = contact_list.begin(); it != contact_list.end(); it++)
		{
			if( (*it).Name == str )
				list.push_back(*it);
		}
		
		return list;
	}
};
