/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/


#include "formnew.h"

FormNew::FormNew(QWidget* parent, const char* name, WFlags fl)
: FormNewBase(parent, name, fl)
{

}

FormNew::FormNew(QWidget* parent, const QString& address, const QString& message)
: FormNewBase(parent, 0, 0)
{
	txtMess->setText( message );
	lineTo->setText( address );
}

FormNew::~FormNew()
{
	//QMessageBox::warning(this, "", "ok");
}
void FormNew::txtMessChanged()
{
	int l = txtMess->text().length();
	statusBar()->message(
		QString( l > 1 ? tr("Message : %1 caractres") : tr("Message : %1 caractre")).arg(l)
			    );
}

/*$SPECIALIZATION$*/

void FormNew::prepareSendMessage(bool isDraft)
{
	if(lineTo->text().isEmpty() || txtMess->text().isEmpty())
	{
		QMessageBox::warning(this, tr("Erreur"), tr("Veuillez complter tous les champs."));
		return;
	}
	
	SMSManager::SMSMessage nsms;

	nsms.setTo( SMSManager::SMSContact("", lineTo->text()) );
	nsms.setMessage( txtMess->text() );
	
	if( isDraft )
		emit messageInDraft(nsms);
	else
		emit messageReady(nsms);
		
	close();
}

void FormNew::actionSend()
{
	prepareSendMessage(false);
}

void FormNew::actionDraft()
{
	prepareSendMessage(true);
}

void FormNew::btnBrowseClick()
{
	FormContacts frm(this);
	frm.exec();
}
