/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/
#include "qpopupdialog.h"

std::vector<QRect> QPopupDialog::popups = std::vector<QRect>();

QPopupDialog::QPopupDialog(const QPixmap& pic, const QString& sound, QWidget *parent, const char *name)
 : QDialog(parent, name, false, WStyle_Customize | WStyle_NoBorder | WStyle_StaysOnTop ), sd_path(sound)
{	
	
	lbl = new QLabel(this);
	
	lbl->setGeometry (0, 0,  pic.width(), pic.height() );
	
	lbl->setPixmap( pic );
	
	size = QRect(QApplication::desktop()->width() - pic.width() - 10, 0, 0, 0 );
	
	if(popups.size() > 0)
	{
		QRect oldSize;
		
		for(std::vector<QRect>::iterator it = popups.begin(); it != popups.end(); it++)
			oldSize =  *it;
			
		if( oldSize.top() + oldSize.height() + size.height() > QApplication::desktop()->height() )
		{
			size.setLeft( oldSize.left() - size.width() );
			size.setTop(0);
		}
		else
		{
			size.setTop( oldSize.top() + oldSize.height() );
		}
		
	}
	
	size.setHeight( pic.height() );
	size.setWidth( pic.width() );
	
	this->setGeometry( size );
	
	popups.push_back( size );
	
	
}

QPopupDialog::~QPopupDialog()
{
	DB_MSG("~QPopupDialog()");
}

void QPopupDialog::show()
{
	if( sd_path != QSTRING_EMPTY && QSound::available() )
		QSound::play( sd_path );
	
	this->setFixedSize ( QSize( size.width(), 0 ) );
	QDialog::show();
	for(int i = 1; i < size.height(); i+=2)
	{
		this->setFixedSize ( QSize( size.width(), i ) );
		SLEEP(2500);
	}
	this->setFixedSize( QSize( size.width(), size.height() ) );
}


void QPopupDialog::close()
{
	for(int i = size.height(); i > 0; i-=2)
	{
		this->setFixedSize( size.width(), i );
		SLEEP(2500);
	}	
	QDialog::close();

	for(std::vector<QRect>::iterator it = popups.begin(); it != popups.end(); it++)
	{
		if( (*it) == size)
		{
			popups.erase(it);
			break;
		}
	}
}

void QPopupDialog::mousePressEvent(QMouseEvent * e)
{
	if( !((e->x() > (size.width() - 10) ) && (e->y() < 10)) ) 
		emit popupClicked();

	this->close();
}
