/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef QPOPUPDIALOG_H
#define QPOPUPDIALOG_H

#include <qdialog.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qapplication.h>
#include <qevent.h>
#include <vector>
#include "misch.h"
#include <qsound.h> 

#include <unistd.h>

#define SLEEP(u) usleep(u); \
		 current_app->processEvents(10)


extern QApplication* current_app;
/**
@author GUILLAUME Nicolas
*/

class QPopupDialog : public QDialog
{
Q_OBJECT
private:
	QString sd_path;
	QLabel* lbl;
	QRect size;
	static std::vector<QRect> popups;
	
public:
	QPopupDialog(const QPixmap&, const QString& sound = QSTRING_EMPTY,
			QWidget *parent = 0, const char *name = 0);
	~QPopupDialog();
	
	void show();
	void close();

protected:
	void mousePressEvent(QMouseEvent * e);
    
signals:
	void popupClicked();

};

#endif
