#!/bin/sh
FILES="xqt-gtk-jumbo xqt-apps xqt-mozilla java xqt-openoffice xqt-games"

echo "X/Qt jumbo cramfs installer - version 0.3.4"

if [ "`id -u`" != "0" ]; then 
  echo "error: you have to be root to run this!"
  exit 1
fi 
if [ "`which awk`" = "" ]; then
  echo "error: awk not found! please install it first."
  exit 1
fi
if [ "`which wc`" = "" ]; then
  echo "warning: wc not found!"
fi
if [ "`which mount`" = "" ]; then
  echo "warning: mount not found!"
fi

MOUNTBASE=/mnt/xqt
if [ "`which automounter`" != "" ]; then
  echo "automounter is installed."
  echo "stopping loop devices..."
  automounter stop
else
  echo "automounter is not installed."
  echo "it is recommended to install automounter or something similar"
fi

CRAMS=0
for i in $FILES
do                 
  CHECK=`ls ${i}* 2>/dev/null| wc -l`
  if [ $CHECK -ne 0 ]; then
    CRAMS=`echo $CRAMS|awk '{print $1+1}'`
  fi
done
LOOPS=`ls /dev/loop* -l|wc -l|awk '{print $1}'`
echo "The system has $LOOPS loop devices."
echo "There are $CRAMS cramfs images."
if [ $LOOPS -lt $CRAMS ]; then
  if [ "`which mknod`" = "" ]; then
    echo "error: mknod not found!"
    exit 1
  else 
    echo ""
    echo "...creating additional loop devices"
    for i in 2 3 4 5 6
    do
      if [ ! -e /dev/loop$i ]; then
        echo "  mknod /dev/loop$i b 7 $i"
        mknod /dev/loop$i b 7 $i 2>/dev/null
      fi
    done    
    echo ""
    echo "You will need to recreate the additional loop devices after each reboot!"
  fi
fi

for i in $FILES
do
  XQTJUMBO=$i
  XQTCRAM=$XQTJUMBO.cramfs
  XQTMOUNT=$MOUNTBASE/$XQTJUMBO
  echo "...checking for $XQTCRAM"
  if [ -f $XQTCRAM.zip ] && [ ! -f $XQTCRAM ]; then
    echo "...found $XQTCRAM.zip"
    if [ "`which unzip`" = "" ]; then
      echo "error: unzip not found!"
      exit 1
    else
      echo "...uncompressing"
      unzip $XQTCRAM.zip
    fi
  fi
  if [ -f $XQTCRAM.tgz ] && [ ! -f $XQTCRAM ]; then
    echo "...found $XQTCRAM.tgz"
    if [ "`which zcat`" = "" ] || [ "`which tar`" = "" ]; then
      echo "error: zcat or tar not found!"
      exit 1
    else
      echo "...uncompressing"
      zcat $XQTCRAM.tgz|tar xf -
    fi
  fi
  if [ -f $XQTCRAM.tar.gz ] && [ ! -f $XQTCRAM ]; then
    echo "...found $XQTCRAM.tar.gz"
    if [ "`which zcat`" = "" ] || [ "`which tar`" = "" ]; then
      echo "error: zcat or tar not found!"
      exit 1
    else
      echo "...uncompressing"
      zcat $XQTCRAM.tar.gz|tar xf -
    fi
  fi
  if [ -f $XQTCRAM.gz ] && [ ! -f $XQTCRAM ]; then
    echo "...found $XQTCRAM.gz"
    if [ "`which gzip`" = "" ]; then
      echo "error: gzip not found!"
      exit 1
    else
      echo "...uncompressing"
      gzip -d $XQTCRAM.gz
    fi
  fi
  if [ -f $XQTCRAM ]; then
    echo "...installing $XQTJUMBO to `pwd`"
    if [ ! -d $XQTMOUNT ]; then
      mkdir -p $XQTMOUNT 
    fi
    if [ "`grep $XQTCRAM /etc/fstab`" = "" ]; then
      echo "`pwd`/$XQTCRAM $XQTMOUNT cramfs loop 0 0" >> /etc/fstab
    fi
    CRAM=`basename $XQTCRAM`
    if [ "`grep $CRAM /etc/fstab`|wc -l|awk '{print $1}'" != "1" ]; then
      echo "Warning: ambiguous entry for $CRAM found in /etc/fstab"
    fi
    if [ "`mount|grep $XQTMOUNT`" = "" ]; then
      mount `pwd`/$XQTCRAM
    fi
    for i in `ls $XQTMOUNT/*-setup 2>/dev/null`
    do 
      SETUP=$i
      if [ "$SETUP" != "" ] && [ -f $SETUP ]; then
        $SETUP
      fi
    done
  else
    echo "$XQTCRAM not found."
  fi
done
if [ "`which automounter`" != "" ]; then
  echo "starting automounter..."
  automounter start
fi
echo "X/Qt installed and configured (if found)."
